package com.github.argon4w.acceleratedrendering.features.items.mixins.gui;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.GuiBatchingController;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.checkerframework.checker.units.qual.A;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_465.class)
public abstract class AbstractContainerScreenMixin {

	@Inject(
			method	= "render",
			at		= @At("HEAD")
	)
	public void startBatching(
			class_332		guiGraphics,
			int				mouseX,
			int				mouseY,
			float			partialTick,
			CallbackInfo	ci
	) {
		GuiBatchingController.startBatching();
	}

	@Inject(
			method	= "render",
			at		= @At(
					value	= "INVOKE",
					target	= "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V",
					shift	= At.Shift.BEFORE
			)
	)
	public void flushBatching(
			class_332		guiGraphics,
			int				mouseX,
			int				mouseY,
			float			partialTick,
			CallbackInfo	ci
	) {
		GuiBatchingController.flushBatching(guiGraphics);
	}

	@Inject(
			method	= "renderSlotHighlight",
			at		= @At("HEAD")
	)
    private static void startRenderHighlight(
        class_332 guiGraphics, int x, int y, int blitOffset, CallbackInfo ci
    ) {
		if (CoreFeature.isGuiBatching()) {
			AcceleratedItemRenderingFeature.GUI_OVERLAY_TARGET.method_1235(false);
		}
	}

	@Inject(
			method	= "renderSlotHighlight",
			at		= @At("TAIL")
	)
    private static void stopRenderHighlight(
        class_332 guiGraphics, int x, int y, int blitOffset, CallbackInfo ci
    ) {
		if (CoreFeature.isGuiBatching()) {
			class_310.method_1551().method_1522().method_1235(false);
		}
	}
}
