package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import lombok.Getter;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@Getter
@ExtensionMethod(BakedModelExtension.class)
@Mixin			(class_1095.class)
public abstract class MultipartBakedModelMixin implements IAcceleratedBakedModel {


	@Unique private			boolean											accelerated;
	@Unique private			boolean											acceleratedInHand;
	@Unique private			boolean											acceleratedInGui;

	@Shadow @Final private	List<Pair<Predicate<class_2680>, class_1087>>	selectors;

	@Shadow @Final private Map<class_2680, BitSet> selectorCache;

	@Inject(
			method	= "<init>",
			at		= @At("TAIL")
	)
	public void checkAccelerationSupport(List<Pair<Predicate<class_2680>, class_1087>> selectors, CallbackInfo ci) {
		accelerated			= true;
		acceleratedInHand	= true;
		acceleratedInGui	= true;

		for (Pair<Predicate<class_2680>, class_1087> selector : selectors) {
			var extension = selector.getRight().getAccelerated();

			accelerated			&= extension.isAccelerated		();
			acceleratedInHand	&= extension.isAcceleratedInHand();
			acceleratedInGui	&= extension.isAcceleratedInGui	();
		}
	}

	@Override
	public void renderItemFast(
			class_1799					itemStack,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							light,
			int							overlay
	) {

	}



	@Override
	public void renderBlockFast(
			class_2680					state,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							light,
			int							overlay,
			int							color
	) {
		var bitSet	= selectorCache.get(state);
		if (bitSet == null) {
			bitSet = new BitSet();
			for(int i = 0; i < this.selectors.size(); ++i) {
				Pair<Predicate<class_2680>, class_1087> pair = this.selectors.get(i);
				if ((pair.getLeft()).test(state)) {
					bitSet.set(i);
				}
			}
			this.selectorCache.put(state, bitSet);
		}
		var seed	= random.method_43055	();

		for (var j = 0; j < bitSet.length(); j ++) {
			if (bitSet.get(j)) {
				selectors
						.get			(j)
						.getRight		()
						.getAccelerated	()
						.renderBlockFast(
								state,
								class_5819.method_43049(seed),
								pose,
								extension,
								light,
								overlay,
								getCustomColor(-1, color)
						);
			}
		}
	}

	@Override
	public int getCustomColor(int layer, int color) {
		return color;
	}
}
