/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.compat.trinkets;

import com.github.argon4w.acceleratedrendering.configs.FeatureConfig;
import com.github.argon4w.acceleratedrendering.configs.FeatureStatus;
import com.github.argon4w.acceleratedrendering.features.filter.FilterType;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class TrinketsCompatFeature {
    public static final Deque<FeatureStatus> LAYER_ACCELERATION_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    public static final Deque<FeatureStatus> CURIOS_ITEM_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Set<class_1792> CURIOS_ITEM_FILTER_VALUES = new ReferenceOpenHashSet();

    public static boolean isEnabled() {
        return FeatureConfig.CONFIG.trinketsCompatFeatureStatus.get() == FeatureStatus.ENABLED;
    }

    public static boolean testTrinketsItem(class_1799 itemStack) {
        return TrinketsCompatFeature.getTrinketsItemFilterType().test(CURIOS_ITEM_FILTER_VALUES, itemStack.method_7909());
    }

    public static boolean shouldAccelerateTrinkets() {
        return TrinketsCompatFeature.getLayerAccelerationSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldFilterTrinketsItems() {
        return TrinketsCompatFeature.getTrinketsItemFilterSetting() == FeatureStatus.ENABLED;
    }

    public static FilterType getTrinketsItemFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.trinketsItemFilterType.get());
    }

    public static void disableLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableTrinketsItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void forceEnableLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableTrinketsItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceSetLayerAcceleration(FeatureStatus status) {
        LAYER_ACCELERATION_CONTROLLER_STACK.push(status);
    }

    public static void forceSetTrinketsItemFilter(FeatureStatus status) {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void resetLayerAcceleration() {
        LAYER_ACCELERATION_CONTROLLER_STACK.pop();
    }

    public static void resetTrinketsItemFilter() {
        CURIOS_ITEM_FILTER_CONTROLLER_STACK.pop();
    }

    public static FeatureStatus getLayerAccelerationSetting() {
        return LAYER_ACCELERATION_CONTROLLER_STACK.isEmpty() ? TrinketsCompatFeature.getDefaultLayerAccelerationSettings() : LAYER_ACCELERATION_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getTrinketsItemFilterSetting() {
        return CURIOS_ITEM_FILTER_CONTROLLER_STACK.isEmpty() ? TrinketsCompatFeature.getDefaultTrinketsItemFilterSetting() : CURIOS_ITEM_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getDefaultLayerAccelerationSettings() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.trinketsCompatLayerAcceleration.get());
    }

    public static FeatureStatus getDefaultTrinketsItemFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.trinketsItemFilter.get());
    }

    static {
        ((List)FeatureConfig.CONFIG.trinketsItemFilterValues.get()).forEach(string -> CURIOS_ITEM_FILTER_VALUES.add((class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)string))));
    }
}

