/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_293;

public class AcceleratedBufferSources
implements IAcceleratedBufferSource {
    private final Map<class_293, AcceleratedBufferSource> sources;
    private final Set<class_293.class_5596> validModes;
    private final Set<String> invalidNames;
    private final boolean canSort;

    private AcceleratedBufferSources(Map<class_293, AcceleratedBufferSource> sources, Set<class_293.class_5596> validModes, Set<String> invalidNames, boolean canSort) {
        this.sources = sources;
        this.validModes = validModes;
        this.invalidNames = invalidNames;
        this.canSort = canSort;
    }

    @Override
    public AcceleratedBufferBuilder getBuffer(class_1921 renderType, Runnable before, Runnable after, int layer) {
        if (renderType != null && (CoreFeature.shouldForceAccelerateTranslucent() || this.canSort || !renderType.field_21402) && this.validModes.contains(renderType.field_20973) && !this.invalidNames.contains(renderType.field_21363) && this.sources.containsKey(renderType.field_20972)) {
            return this.sources.get(renderType.field_20972).getBuffer(renderType, before, after, layer);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<class_293, AcceleratedBufferSource> sources = new Reference2ObjectOpenHashMap();
        private final Set<class_293.class_5596> validModes = new ReferenceOpenHashSet();
        private final Set<String> invalidNames = new ObjectOpenHashSet();
        private boolean canSort = false;

        private Builder() {
        }

        public Builder source(AcceleratedBufferSource bufferSource) {
            for (class_293 format : bufferSource.getEnvironment().getVertexFormats()) {
                this.sources.put(format, bufferSource);
            }
            return this;
        }

        public Builder mode(class_293.class_5596 mode) {
            this.validModes.add(mode);
            return this;
        }

        public Builder invalid(String name) {
            this.invalidNames.add(name);
            return this;
        }

        public Builder canSort() {
            this.canSort = true;
            return this;
        }

        public AcceleratedBufferSources build() {
            return new AcceleratedBufferSources(this.sources, this.validModes, this.invalidNames, this.canSort);
        }
    }
}

