/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.blocks.cache;

import com.github.argon4w.acceleratedrendering.core.buffers.blocks.cache.IBlockBufferBindingCache;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import sun.misc.Unsafe;

public class UnsafeMemoryBlockBufferBindingCache
implements IBlockBufferBindingCache {
    public static final Unsafe UNSAFE = UnsafeAccess.UNSAFE;
    public static final long BLOCK_BUFFER_BINDING_SIZE = 24L;
    public static final long BUFFER_OFFSET = 0L;
    public static final long OFFSET_OFFSET = 8L;
    public static final long SIZE_OFFSET = 16L;
    private final long address;

    public UnsafeMemoryBlockBufferBindingCache(int size) {
        this.address = UNSAFE.allocateMemory((long)size * 24L);
    }

    @Override
    public void delete() {
        UNSAFE.freeMemory(this.address);
    }

    @Override
    public void setup(int bindingPoint, int buffer, long offset, long size) {
        long bindingAddress = this.address + (long)bindingPoint * 24L;
        UNSAFE.putInt(bindingAddress + 0L, buffer);
        UNSAFE.putLong(bindingAddress + 8L, offset);
        UNSAFE.putLong(bindingAddress + 16L, size);
    }

    @Override
    public int getBuffer(int bindingPoint) {
        return UNSAFE.getInt(this.address + (long)bindingPoint * 24L + 0L);
    }

    @Override
    public long getOffset(int bindingPoint) {
        return UNSAFE.getLong(this.address + (long)bindingPoint * 24L + 8L);
    }

    @Override
    public long getSize(int bindingPoint) {
        return UNSAFE.getLong(this.address + (long)bindingPoint * 24L + 16L);
    }
}

