/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.environments;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.VertexFormatMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.programs.culling.LoadCullingProgramSelectorEvent;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.MeshUploadingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverrides;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.LoadShaderProgramOverridesEvent;
import com.github.argon4w.acceleratedrendering.core.programs.processing.IPolygonProcessor;
import com.github.argon4w.acceleratedrendering.core.programs.processing.LoadPolygonProcessorEvent;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.neoforged.fml.ModLoader;

public class VanillaBufferEnvironment
implements IBufferEnvironment {
    private final class_293 vertexFormat;
    private final IMemoryLayout<class_296> layout;
    private final IShaderProgramOverrides shaderProgramOverrides;
    private final MeshUploadingProgramDispatcher meshUploadingProgramDispatcher;
    private final TransformProgramDispatcher transformProgramDispatcher;
    private final ICullingProgramSelector cullingProgramSelector;
    private final IPolygonProcessor polygonProcessor;

    public VanillaBufferEnvironment(class_293 vertexFormat, class_2960 uploadingProgramKey, class_2960 transformProgramKey) {
        TransformProgramDispatcher.Default defaultTransformOverride = new TransformProgramDispatcher.Default(transformProgramKey, 16L);
        MeshUploadingProgramDispatcher.Default defaultUploadingOverride = new MeshUploadingProgramDispatcher.Default(uploadingProgramKey, 20L);
        this.vertexFormat = vertexFormat;
        this.layout = new VertexFormatMemoryLayout(vertexFormat);
        this.shaderProgramOverrides = ModLoader.postEventWithReturn(new LoadShaderProgramOverridesEvent(this.vertexFormat)).getOverrides(defaultTransformOverride, defaultUploadingOverride);
        this.cullingProgramSelector = ModLoader.postEventWithReturn(new LoadCullingProgramSelectorEvent(this.vertexFormat)).getSelector();
        this.polygonProcessor = ModLoader.postEventWithReturn(new LoadPolygonProcessorEvent(this.vertexFormat)).getProcessor();
        this.meshUploadingProgramDispatcher = new MeshUploadingProgramDispatcher();
        this.transformProgramDispatcher = new TransformProgramDispatcher();
    }

    @Override
    public void setupBufferState() {
        this.vertexFormat.method_22649();
    }

    @Override
    public Set<class_293> getVertexFormats() {
        return Set.of(this.vertexFormat);
    }

    @Override
    public IMemoryLayout<class_296> getLayout() {
        return this.layout;
    }

    @Override
    public IServerBuffer getImmediateMeshBuffer() {
        return (IServerBuffer)((List)ServerMesh.Builder.BUFFERS.get(this.layout)).getFirst();
    }

    @Override
    public ITransformShaderProgramOverride getTransformProgramOverride(class_1921 renderType) {
        return this.shaderProgramOverrides.getTransformOverrides().get(renderType);
    }

    @Override
    public IUploadingShaderProgramOverride getUploadingProgramOverride(class_1921 renderType) {
        return this.shaderProgramOverrides.getUploadingOverrides().get(renderType);
    }

    @Override
    public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
        return this.meshUploadingProgramDispatcher;
    }

    @Override
    public TransformProgramDispatcher selectTransformProgramDispatcher() {
        return this.transformProgramDispatcher;
    }

    @Override
    public ICullingProgramDispatcher selectCullingProgramDispatcher(class_1921 renderType) {
        return this.cullingProgramSelector.select(renderType);
    }

    @Override
    public IPolygonProgramDispatcher selectProcessingProgramDispatcher(class_293.class_5596 mode) {
        return this.polygonProcessor.select(mode);
    }

    @Override
    public boolean isAccelerated(class_293 vertexFormat) {
        return this.vertexFormat == vertexFormat;
    }

    @Override
    public int getVertexSize() {
        return this.vertexFormat.method_1362();
    }
}

