/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeShader;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderDefinition;
import com.github.argon4w.acceleratedrendering.core.programs.LoadComputeShaderEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.neoforged.fml.ModLoader;
import org.apache.commons.io.IOUtils;

public class ComputeShaderProgramLoader
extends class_4080<Map<class_2960, ShaderSource>> {
    public static final ComputeShaderProgramLoader INSTANCE = new ComputeShaderProgramLoader();
    private static final Map<class_2960, ComputeProgram> COMPUTE_SHADERS = new Object2ObjectOpenHashMap();
    private static boolean LOADED = false;

    protected Map<class_2960, ShaderSource> prepare(class_3300 resourceManager, class_3695 profiler) {
        try {
            Object2ObjectOpenHashMap shaderSources = new Object2ObjectOpenHashMap();
            Map<class_2960, ComputeShaderDefinition> shaderLocations = ModLoader.postEventWithReturn(new LoadComputeShaderEvent()).build();
            for (class_2960 key : shaderLocations.keySet()) {
                ComputeShaderDefinition definition = shaderLocations.get(key);
                class_2960 resourceLocation = definition.location();
                int barrierFlags = definition.barrierFlags();
                if (resourceLocation == null) {
                    throw new IllegalStateException("Found empty shader location on: \"" + String.valueOf(key) + "\"");
                }
                Optional resource = resourceManager.method_14486(resourceLocation);
                if (resource.isEmpty()) {
                    throw new IllegalStateException("Cannot found compute shader: \"" + String.valueOf(resourceLocation) + "\"");
                }
                InputStream stream = ((class_3298)resource.get()).method_14482();
                try {
                    shaderSources.put((Object)key, (Object)new ShaderSource(IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8), barrierFlags));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            return shaderSources;
        }
        catch (Exception e) {
            throw new class_148(class_128.method_560((Throwable)e, (String)"Exception while loading compute shader"));
        }
    }

    protected void apply(Map<class_2960, ShaderSource> shaderSources, class_3300 resourceManager, class_3695 profiler) {
        RenderSystem.recordRenderCall(() -> {
            try {
                for (class_2960 key : shaderSources.keySet()) {
                    ShaderSource source = (ShaderSource)shaderSources.get(key);
                    String shaderSource = source.source;
                    int barrierFlags = source.barrierFlags;
                    ComputeProgram program = new ComputeProgram(barrierFlags);
                    ComputeShader computeShader = new ComputeShader();
                    computeShader.setShaderSource(shaderSource);
                    computeShader.compileShader();
                    if (!computeShader.isCompiled()) {
                        throw new IllegalStateException("Shader \"" + String.valueOf(key) + "\" failed to compile because of the following errors: " + computeShader.getInfoLog());
                    }
                    program.attachShader(computeShader);
                    program.linkProgram();
                    if (!program.isLinked()) {
                        throw new IllegalStateException("Program \"" + String.valueOf(key) + "\" failed to link because of the following errors: " + program.getInfoLog());
                    }
                    computeShader.delete();
                    COMPUTE_SHADERS.put(key, program);
                }
            }
            catch (Exception e) {
                throw new class_148(class_128.method_560((Throwable)e, (String)"Exception while compiling/linking compute shader"));
            }
            finally {
                LOADED = true;
            }
        });
    }

    public static ComputeProgram getProgram(class_2960 resourceLocation) {
        ComputeProgram program = COMPUTE_SHADERS.get(resourceLocation);
        if (program == null) {
            throw new IllegalStateException("Get shader program \"" + String.valueOf(resourceLocation) + "\" too early! Program is not loaded yet!");
        }
        return program;
    }

    public static void delete() {
        for (ComputeProgram program : COMPUTE_SHADERS.values()) {
            program.delete();
        }
        LOADED = false;
    }

    public static boolean isProgramsLoaded() {
        return LOADED;
    }

    public record ShaderSource(String source, int barrierFlags) {
    }
}

