/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.utils;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.nio.IntBuffer;
import net.minecraft.class_1011;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.lwjgl.opengl.GL46;
import org.lwjgl.system.MemoryStack;

public class TextureUtils
implements class_4013 {
    public static final TextureUtils INSTANCE = new TextureUtils();
    private static final Object2ObjectLinkedOpenHashMap<class_2960, class_1011> IMAGE_CACHE = new Object2ObjectLinkedOpenHashMap();

    public void method_14491(class_3300 resourceManager) {
        IMAGE_CACHE.clear();
    }

    public static class_1011 downloadTexture(class_1921 renderType, int mipmapLevel) {
        class_2960 textureResourceLocation = RenderTypeUtils.getTextureLocation(renderType);
        if (textureResourceLocation == null) {
            return null;
        }
        class_1011 image = (class_1011)IMAGE_CACHE.getAndMoveToFirst((Object)textureResourceLocation);
        if (image != null) {
            return image;
        }
        class_310.method_1551().method_1531().method_4619(textureResourceLocation).method_23207();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer widthBuffer = stack.callocInt(1);
            IntBuffer heightBuffer = stack.callocInt(1);
            GL46.glGetTexLevelParameteriv((int)3553, (int)mipmapLevel, (int)4096, (IntBuffer)widthBuffer);
            GL46.glGetTexLevelParameteriv((int)3553, (int)mipmapLevel, (int)4097, (IntBuffer)heightBuffer);
            int width = widthBuffer.get(0);
            int height = heightBuffer.get(0);
            if (width == 0 || height == 0) {
                class_1011 class_10112 = null;
                return class_10112;
            }
            class_1011 nativeImage = new class_1011(width, height, false);
            nativeImage.method_4327(mipmapLevel, false);
            IMAGE_CACHE.putAndMoveToFirst((Object)textureResourceLocation, (Object)nativeImage);
            if (IMAGE_CACHE.size() > CoreFeature.getCachedImageSize()) {
                ((class_1011)IMAGE_CACHE.removeLast()).close();
            }
            class_1011 class_10113 = nativeImage;
            return class_10113;
        }
    }
}

