/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_1087;
import net.minecraft.class_1097;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1097.class})
public class WeightedBakedModelMixin
implements IAcceleratedBakedModel {
    @Unique
    private boolean accelerated;
    @Unique
    private boolean acceleratedInHand;
    @Unique
    private boolean acceleratedInGui;
    @Shadow
    @Final
    private List<class_6008.class_6010<class_1087>> field_5434;
    @Shadow
    @Final
    private int field_5433;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void checkAccelerationSupport(List<class_6008.class_6010<class_1087>> list, CallbackInfo ci) {
        this.accelerated = true;
        this.acceleratedInHand = true;
        this.acceleratedInGui = true;
        for (class_6008.class_6010<class_1087> wrapper : list) {
            IAcceleratedBakedModel extension = BakedModelExtension.getAccelerated((class_1087)wrapper.comp_2542());
            this.accelerated &= extension.isAccelerated();
            this.acceleratedInHand &= extension.isAcceleratedInHand();
            this.acceleratedInGui &= extension.isAcceleratedInGui();
        }
    }

    @Override
    public void renderItemFast(class_1799 itemStack, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int light, int overlay) {
        Optional model = class_6011.method_34985(this.field_5434, (int)(Math.abs((int)random.method_43055()) % this.field_5433));
        if (model.isPresent()) {
            BakedModelExtension.getAccelerated((class_1087)((class_6008.class_6010)model.get()).comp_2542()).renderItemFast(itemStack, random, pose, extension, light, overlay);
        }
    }

    @Override
    public void renderBlockFast(class_2680 state, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int light, int overlay, int color) {
        Optional model = class_6011.method_34985(this.field_5434, (int)(Math.abs((int)random.method_43055()) % this.field_5433));
        if (model.isPresent()) {
            BakedModelExtension.getAccelerated((class_1087)((class_6008.class_6010)model.get()).comp_2542()).renderBlockFast(state, random, pose, extension, light, overlay, this.getCustomColor(-1, color));
        }
    }

    @Override
    public int getCustomColor(int layer, int color) {
        return color;
    }

    @Override
    @Generated
    public boolean isAccelerated() {
        return this.accelerated;
    }

    @Override
    @Generated
    public boolean isAcceleratedInHand() {
        return this.acceleratedInHand;
    }

    @Override
    @Generated
    public boolean isAcceleratedInGui() {
        return this.acceleratedInGui;
    }

    @Generated
    public List<class_6008.class_6010<class_1087>> getList() {
        return this.field_5434;
    }

    @Generated
    public int getTotalWeight() {
        return this.field_5433;
    }
}

