/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1095.class})
public abstract class MultipartBakedModelMixin
implements IAcceleratedBakedModel {
    @Unique
    private boolean accelerated;
    @Unique
    private boolean acceleratedInHand;
    @Unique
    private boolean acceleratedInGui;
    @Shadow
    @Final
    private List<Pair<Predicate<class_2680>, class_1087>> field_5427;
    @Shadow
    @Final
    private Map<class_2680, BitSet> field_5431;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void checkAccelerationSupport(List<Pair<Predicate<class_2680>, class_1087>> selectors, CallbackInfo ci) {
        this.accelerated = true;
        this.acceleratedInHand = true;
        this.acceleratedInGui = true;
        for (Pair<Predicate<class_2680>, class_1087> selector : selectors) {
            IAcceleratedBakedModel extension = BakedModelExtension.getAccelerated((class_1087)selector.getRight());
            this.accelerated &= extension.isAccelerated();
            this.acceleratedInHand &= extension.isAcceleratedInHand();
            this.acceleratedInGui &= extension.isAcceleratedInGui();
        }
    }

    @Override
    public void renderItemFast(class_1799 itemStack, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int light, int overlay) {
    }

    @Override
    public void renderBlockFast(class_2680 state, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int light, int overlay, int color) {
        BitSet bitSet = this.field_5431.get(state);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < this.field_5427.size(); ++i) {
                Pair<Predicate<class_2680>, class_1087> pair = this.field_5427.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitSet.set(i);
            }
            this.field_5431.put(state, bitSet);
        }
        long seed = random.method_43055();
        for (int j = 0; j < bitSet.length(); ++j) {
            if (!bitSet.get(j)) continue;
            BakedModelExtension.getAccelerated((class_1087)this.field_5427.get(j).getRight()).renderBlockFast(state, class_5819.method_43049((long)seed), pose, extension, light, overlay, this.getCustomColor(-1, color));
        }
    }

    @Override
    public int getCustomColor(int layer, int color) {
        return color;
    }

    @Override
    @Generated
    public boolean isAccelerated() {
        return this.accelerated;
    }

    @Override
    @Generated
    public boolean isAcceleratedInHand() {
        return this.acceleratedInHand;
    }

    @Override
    @Generated
    public boolean isAcceleratedInGui() {
        return this.acceleratedInGui;
    }

    @Generated
    public List<Pair<Predicate<class_2680>, class_1087>> getSelectors() {
        return this.field_5427;
    }

    @Generated
    public Map<class_2680, BitSet> getSelectorCache() {
        return this.field_5431;
    }
}

