/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_293;

public class AcceleratedBufferSources
implements IAcceleratedBufferSource {
    private final Map<class_293, AcceleratedBufferSource> sources;
    private final Set<class_293.class_5596> validModes;
    private final boolean supportTranslucent;
    private final boolean supportDynamic;

    private AcceleratedBufferSources(Map<class_293, AcceleratedBufferSource> sources, Set<class_293.class_5596> validModes, boolean supportTranslucent, boolean supportDynamic) {
        this.sources = sources;
        this.validModes = validModes;
        this.supportTranslucent = supportTranslucent;
        this.supportDynamic = supportDynamic;
    }

    @Override
    public AcceleratedBufferBuilder getBuffer(class_1921 renderType, Runnable before, Runnable after, int layer) {
        if (renderType != null && (CoreFeature.shouldForceAccelerateTranslucent() || this.supportTranslucent || !RenderTypeUtils.isTranslucent(renderType)) && (CoreFeature.shouldCacheDynamicRenderType() || this.supportDynamic || !RenderTypeUtils.isDynamic(renderType)) && this.validModes.contains(renderType.method_23033()) && this.sources.containsKey(renderType.method_23031())) {
            return this.sources.get(renderType.method_23031()).getBuffer(renderType, before, after, layer);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<class_293, AcceleratedBufferSource> sources = new Reference2ObjectOpenHashMap();
        private final Set<class_293.class_5596> validModes = new ReferenceOpenHashSet();
        private boolean supportTranslucent = false;
        private boolean supportDynamic = false;

        private Builder() {
        }

        public Builder source(AcceleratedBufferSource bufferSource) {
            for (class_293 format : bufferSource.getEnvironment().getVertexFormats()) {
                this.sources.put(format, bufferSource);
            }
            return this;
        }

        public Builder mode(class_293.class_5596 mode) {
            this.validModes.add(mode);
            return this;
        }

        public Builder supportTranslucent() {
            this.supportTranslucent = true;
            return this;
        }

        public Builder supportDynamic() {
            this.supportDynamic = true;
            return this;
        }

        public AcceleratedBufferSources build() {
            return new AcceleratedBufferSources(this.sources, this.validModes, this.supportTranslucent, this.supportDynamic);
        }
    }
}

