/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.utils.MemUtils;
import lombok.Generated;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryUtil;

public class SimpleMemoryInterface
implements IMemoryInterface {
    private final long offset;
    private final long size;

    @Override
    public void putByte(long address, byte value) {
        MemoryUtil.memPutByte((long)(address + this.offset), (byte)value);
    }

    @Override
    public void putShort(long address, short value) {
        MemoryUtil.memPutShort((long)(address + this.offset), (short)value);
    }

    @Override
    public void putInt(long address, int value) {
        MemoryUtil.memPutInt((long)(address + this.offset), (int)value);
    }

    @Override
    public void putInt(long address, long value) {
        MemoryUtil.memPutInt((long)(address + this.offset), (int)((int)value));
    }

    @Override
    public void putFloat(long address, float value) {
        MemoryUtil.memPutFloat((long)(address + this.offset), (float)value);
    }

    @Override
    public void putNormal(long address, float value) {
        MemUtils.putNormal(address + this.offset, value);
    }

    @Override
    public void putMatrix4f(long address, Matrix4f value) {
        MemUtils.putMatrix4f(address + this.offset, value);
    }

    @Override
    public void putMatrix3f(long address, Matrix3f value) {
        MemUtils.putMatrix3f(address + this.offset, value);
    }

    @Override
    public IMemoryInterface at(int index) {
        return new SimpleMemoryInterface((long)index * this.size + this.offset, this.size);
    }

    @Generated
    public SimpleMemoryInterface(long offset, long size) {
        this.offset = offset;
        this.size = size;
    }
}

