/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.NullMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatMemoryLayout
implements IMemoryLayout<class_296> {
    private final long size;
    private final Reference2IntMap<class_296> offsets;
    private final Reference2ObjectMap<class_296, IMemoryInterface> interfaces;

    public VertexFormatMemoryLayout(class_293 vertexFormat) {
        ImmutableList elements = vertexFormat.method_1357();
        int count = elements.size();
        this.size = vertexFormat.method_1362();
        this.offsets = new Reference2IntLinkedOpenHashMap();
        this.interfaces = new Reference2ObjectOpenHashMap(count);
        for (int i = 0; i < count; ++i) {
            class_296 element = (class_296)elements.get(i);
            int offset = vertexFormat.field_1597.getInt(i);
            this.interfaces.put((Object)element, (Object)new SimpleMemoryInterface(offset, this.size));
            this.offsets.put((Object)element, offset);
        }
    }

    @Override
    public IMemoryInterface getElement(class_296 element) {
        return (IMemoryInterface)this.interfaces.getOrDefault((Object)element, (Object)NullMemoryInterface.INSTANCE);
    }

    @Override
    public int getElementOffset(class_296 element) {
        return this.offsets.getOrDefault((Object)element, -1);
    }

    @Override
    public boolean containsElement(class_296 element) {
        return this.offsets.containsKey((Object)element);
    }

    @Override
    public long getSize() {
        return this.size;
    }
}

