/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.dispatchers;

import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class FixedPolygonProgramDispatcher
implements IPolygonProgramDispatcher {
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    private final class_293.class_5596 mode;
    private final ComputeProgram program;
    private final Uniform polygonCountUniform;
    private final Uniform vertexOffsetUniform;

    public FixedPolygonProgramDispatcher(class_293.class_5596 mode, class_2960 key) {
        this.mode = mode;
        this.program = ComputeShaderProgramLoader.getProgram(key);
        this.polygonCountUniform = this.program.getUniform("polygonCount");
        this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
    }

    @Override
    public int dispatch(AcceleratedBufferBuilder builder) {
        int vertexCount = builder.getTotalVertexCount();
        int polygonCount = vertexCount / this.mode.field_27384;
        this.polygonCountUniform.uploadUnsignedInt(polygonCount);
        this.vertexOffsetUniform.uploadUnsignedInt((int)(builder.getVertexBuffer().getOffset() / builder.getVertexSize()));
        this.program.useProgram();
        this.program.dispatch((polygonCount + 128 - 1) / 128, 1, 1);
        return this.program.getBarrierFlags();
    }
}

