/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.programs.dispatchers;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.backends.programs.ComputeProgram;
import com.github.argon4w.acceleratedrendering.core.backends.programs.Uniform;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedRingBuffers;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshUploaderPool;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.utils.FastColorUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.lwjgl.opengl.GL46;

public class MeshUploadingProgramDispatcher {
    private static final int GROUP_SIZE = 128;
    private static final int DISPATCH_COUNT_Y_Z = 1;
    public static final int SPARSE_MESH_BUFFER_INDEX = 5;
    public static final int MESH_BUFFER_INDEX = 7;
    private final Map<IServerBuffer, List<MeshUploaderPool.MeshUploader>> denseUploaders = new Reference2ObjectLinkedOpenHashMap();
    private final Map<IServerBuffer, List<MeshUploaderPool.MeshUploader>> sparseUploaders = new Reference2ObjectLinkedOpenHashMap();
    private IUploadingShaderProgramOverride lastOverride = null;

    public void dispatch(Collection<AcceleratedBufferBuilder> builders, AcceleratedRingBuffers.Buffers buffer) {
        this.lastOverride = null;
        int barriers = 0;
        TransformProgramDispatcher transform = buffer.getBufferEnvironment().selectTransformProgramDispatcher();
        for (AcceleratedBufferBuilder builder : builders) {
            StagingBufferPool.StagingBuffer vertexBuffer = builder.getVertexBuffer();
            StagingBufferPool.StagingBuffer varyingBuffer = builder.getVaryingBuffer();
            int meshVertexCount = builder.getMeshVertexCount();
            vertexBuffer.reserve((long)meshVertexCount * builder.getVertexSize());
            varyingBuffer.reserve((long)meshVertexCount * builder.getVaryingSize());
            vertexBuffer.allocateOffset();
            varyingBuffer.allocateOffset();
        }
        buffer.prepare();
        buffer.bindTransformBuffers();
        for (AcceleratedBufferBuilder builder : builders) {
            int offset = 0;
            int sparseStart = 0;
            StagingBufferPool.StagingBuffer vertexBuffer = builder.getVertexBuffer();
            StagingBufferPool.StagingBuffer varyingBuffer = builder.getVaryingBuffer();
            int vertexCount = builder.getVertexCount();
            long vertexAddress = vertexBuffer.getCurrent();
            long varyingAddress = varyingBuffer.getCurrent();
            long vertexOffset = vertexBuffer.getOffset() / builder.getVertexSize();
            long varyingOffset = varyingBuffer.getOffset() / builder.getVaryingSize();
            for (MeshUploaderPool.MeshUploader uploader : builder.getMeshUploaders().values()) {
                ServerMesh serverMesh = uploader.getServerMesh();
                int meshCount = uploader.getMeshInfos().getMeshCount();
                boolean meshDense = serverMesh.forceDense() || meshCount >= 128;
                IServerBuffer meshBuffer = serverMesh.meshBuffer();
                ReferenceArrayList dense = this.denseUploaders.get(meshBuffer);
                ReferenceArrayList sparse = this.sparseUploaders.get(meshBuffer);
                if (dense == null) {
                    dense = new ReferenceArrayList();
                    sparse = new ReferenceArrayList();
                    this.denseUploaders.put(meshBuffer, (List<MeshUploaderPool.MeshUploader>)dense);
                    this.sparseUploaders.put(meshBuffer, (List<MeshUploaderPool.MeshUploader>)sparse);
                }
                (meshDense ? dense : sparse).add(uploader);
            }
            for (IServerBuffer meshBuffer : this.sparseUploaders.keySet()) {
                for (MeshUploaderPool.MeshUploader uploader : this.sparseUploaders.get(meshBuffer)) {
                    ServerMesh mesh = uploader.getServerMesh();
                    IMeshInfoCache meshInfos = uploader.getMeshInfos();
                    int meshCount = meshInfos.getMeshCount();
                    int meshSize = mesh.size();
                    for (int i = 0; i < meshCount; ++i) {
                        builder.getColorOffset().at(offset).putInt(vertexAddress, FastColorUtils.convert(meshInfos.getColor(i)));
                        builder.getUv1Offset().at(offset).putInt(vertexAddress, meshInfos.getOverlay(i));
                        builder.getUv2Offset().at(offset).putInt(vertexAddress, meshInfos.getLight(i));
                        builder.getVaryingSharing().at(offset).putInt(varyingAddress, meshInfos.getSharing(i));
                        builder.getVaryingMesh().at(offset).putInt(varyingAddress, mesh.offset());
                        builder.getVaryingShouldCull().at(offset).putInt(varyingAddress, meshInfos.getShouldCull(i));
                        builder.getTransformOverride().uploadVarying(varyingAddress, offset);
                        for (int offsetValue = 0; offsetValue < meshSize; ++offsetValue) {
                            builder.getVaryingOffset().at(offset).at(offsetValue).putInt(varyingAddress, offsetValue);
                        }
                        offset += meshSize;
                    }
                }
                int count = offset - sparseStart;
                if (count != 0) {
                    this.lastOverride = null;
                    meshBuffer.bindBase(37074, 5);
                    barriers |= transform.dispatch(builder, vertexBuffer, varyingBuffer, count, (long)(sparseStart + vertexCount) + vertexOffset, (long)(sparseStart + vertexCount) + varyingOffset);
                }
                sparseStart = offset;
            }
            for (IServerBuffer meshBuffer : this.denseUploaders.keySet()) {
                meshBuffer.bindBase(37074, 7);
                for (MeshUploaderPool.MeshUploader uploader : this.denseUploaders.get(meshBuffer)) {
                    IUploadingShaderProgramOverride currentOverride = builder.getUploadingOverride();
                    int meshCount = uploader.getMeshInfos().getMeshCount();
                    ServerMesh mesh = uploader.getServerMesh();
                    int meshSize = mesh.size();
                    int uploadSize = meshCount * meshSize;
                    if (this.lastOverride == null) {
                        this.lastOverride = currentOverride;
                        this.lastOverride.useProgram();
                        this.lastOverride.setupProgram();
                    }
                    transform.resetOverride();
                    uploader.upload();
                    uploader.bindBuffers();
                    barriers |= currentOverride.dispatchUploading(uploadSize, meshCount, meshSize, (int)((long)(offset + vertexCount) + vertexOffset), (int)((long)(offset + vertexCount) + varyingOffset), (int)mesh.offset());
                    offset += uploadSize;
                }
            }
            for (IServerBuffer meshBuffer : this.denseUploaders.keySet()) {
                this.denseUploaders.get(meshBuffer).clear();
                this.sparseUploaders.get(meshBuffer).clear();
            }
        }
        GL46.glMemoryBarrier((int)barriers);
    }

    public void resetOverride() {
        this.lastOverride = null;
    }

    public static class Default
    implements IUploadingShaderProgramOverride {
        private final long meshInfoSize;
        private final ComputeProgram program;
        private final Uniform meshCountUniform;
        private final Uniform meshSizeUniform;
        private final Uniform vertexOffsetUniform;
        private final Uniform varyingOffsetUniform;
        private final Uniform meshOffsetUniform;

        public Default(class_2960 key, long meshInfoSize) {
            this.meshInfoSize = meshInfoSize;
            this.program = ComputeShaderProgramLoader.getProgram(key);
            this.meshCountUniform = this.program.getUniform("meshCount");
            this.meshSizeUniform = this.program.getUniform("meshSize");
            this.vertexOffsetUniform = this.program.getUniform("vertexOffset");
            this.varyingOffsetUniform = this.program.getUniform("varyingOffset");
            this.meshOffsetUniform = this.program.getUniform("meshOffset");
        }

        @Override
        public long getMeshInfoSize() {
            return this.meshInfoSize;
        }

        @Override
        public void useProgram() {
            this.program.useProgram();
        }

        @Override
        public void setupProgram() {
            this.program.setup();
        }

        @Override
        public void uploadMeshInfo(long meshInfoAddress, int meshInfoIndex) {
        }

        @Override
        public int dispatchUploading(int uploadSize, int meshCount, int meshSize, int vertexOffset, int varyingOffset, int meshOffset) {
            this.meshCountUniform.uploadUnsignedInt(meshCount);
            this.meshSizeUniform.uploadUnsignedInt(meshSize);
            this.vertexOffsetUniform.uploadUnsignedInt(vertexOffset);
            this.varyingOffsetUniform.uploadUnsignedInt(varyingOffset);
            this.meshOffsetUniform.uploadUnsignedInt(meshOffset);
            this.program.dispatch((uploadSize + 128 - 1) / 128, 1, 1);
            return this.program.getBarrierFlags();
        }
    }
}

