/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.geckolib.mixins;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.util.RenderUtils;

@Pseudo
@Mixin(value={GeoBone.class})
public class GeoBoneMixin
implements IAcceleratedRenderer<Void> {
    @Shadow(remap=false)
    @Final
    private List<GeoCube> cubes;
    @Unique
    private final Map<IBufferGraph, IMesh> meshes = new Object2ObjectOpenHashMap();
    @Unique
    private final Map<IMeshData, IMesh> merges = new Object2ObjectOpenHashMap();

    @Override
    public void render(class_4588 vertexConsumer, Void context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        IMesh mesh = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (mesh != null) {
            mesh.write(extension, color, light, overlay);
            extension.endTransform();
            return;
        }
        CulledMeshCollector culledMeshCollector = new CulledMeshCollector(extension);
        class_4588 meshBuilder = extension.decorate(culledMeshCollector);
        for (GeoCube cube : this.cubes) {
            class_4587 poseStack = new class_4587();
            RenderUtils.translateToPivotPoint((class_4587)poseStack, (GeoCube)cube);
            RenderUtils.rotateMatrixAroundCube((class_4587)poseStack, (GeoCube)cube);
            RenderUtils.translateAwayFromPivotPoint((class_4587)poseStack, (GeoCube)cube);
            class_4587.class_4665 pose = poseStack.method_23760();
            Matrix4f cubeTransform = pose.method_23761();
            Matrix3f cubeNormal = pose.method_23762();
            for (GeoQuad quad : cube.quads()) {
                if (quad == null) continue;
                Vector3f polygonNormal = cubeNormal.transform(new Vector3f((Vector3fc)quad.normal()));
                for (GeoVertex vertex : quad.vertices()) {
                    Vector4f vertexPosition = cubeTransform.transform(new Vector4f((Vector3fc)vertex.position(), 1.0f));
                    meshBuilder.method_23919(vertexPosition.x, vertexPosition.y, vertexPosition.z, 1.0f, 1.0f, 1.0f, 1.0f, vertex.texU(), vertex.texV(), overlay, 0, polygonNormal.x, polygonNormal.y, polygonNormal.z);
                }
            }
        }
        culledMeshCollector.flush();
        IMeshData data = culledMeshCollector.getData();
        ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
        mesh = this.merges.get(data);
        if (mesh != null) {
            buffer.close();
        } else {
            mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
        }
        this.meshes.put(extension, mesh);
        this.merges.put(data, mesh);
        mesh.write(extension, color, light, overlay);
        extension.endTransform();
    }
}

