/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.ByteBufferBuilder;
import com.github.argon4w.acceleratedrendering.core.utils.DirectionUtils;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.github.argon4w.acceleratedrendering.features.items.colors.FixedColors;
import com.github.argon4w.acceleratedrendering.features.items.colors.ILayerColors;
import com.github.argon4w.acceleratedrendering.features.items.colors.ItemLayerColors;
import com.github.argon4w.acceleratedrendering.features.items.contexts.AcceleratedModelRenderContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1093;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraftforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1093.class})
public abstract class SimpleBakedModelMixin
implements IAcceleratedBakedModel,
IAcceleratedRenderer<AcceleratedModelRenderContext> {
    @Unique
    private final Map<IBufferGraph, Int2ObjectMap<IMesh>> meshes = new Object2ObjectOpenHashMap();
    @Unique
    private final Map<IMeshData, IMesh> merges = new Object2ObjectOpenHashMap();

    @Shadow
    public abstract List<class_777> method_4707(class_2680 var1, class_2350 var2, class_5819 var3);

    @Override
    @Unique
    public void renderItemFast(class_1799 itemStack, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay) {
        extension.doRender(this, new AcceleratedModelRenderContext(random, new ItemLayerColors(itemStack)), pose.method_23761(), pose.method_23762(), combinedLight, combinedOverlay, -1);
    }

    @Override
    public void renderBlockFast(class_2680 state, class_5819 random, class_4587.class_4665 pose, IAcceleratedVertexConsumer extension, int combinedLight, int combinedOverlay, int color) {
        extension.doRender(this, new AcceleratedModelRenderContext(random, new FixedColors(color)), pose.method_23761(), pose.method_23762(), combinedLight, combinedOverlay, -1);
    }

    @Override
    @Unique
    public void render(class_4588 vertexConsumer, AcceleratedModelRenderContext context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        IAcceleratedVertexConsumer extension = VertexConsumerExtension.getAccelerated(vertexConsumer);
        class_5819 randomSource = context.randomSource();
        ILayerColors layerColors = context.layerColors();
        Int2ObjectAVLTreeMap layers = this.meshes.get(extension);
        extension.beginTransform(transform, normal);
        if (layers != null) {
            IntIterator intIterator = layers.keySet().iterator();
            while (intIterator.hasNext()) {
                int layer = (Integer)intIterator.next();
                IMesh mesh = (IMesh)layers.get(layer);
                mesh.write(extension, this.getCustomColor(layer, layerColors.getColor(layer)), light, overlay);
            }
            extension.endTransform();
            return;
        }
        Int2ObjectOpenHashMap culledMeshCollectors = new Int2ObjectOpenHashMap();
        layers = new Int2ObjectAVLTreeMap();
        this.meshes.put(extension, (Int2ObjectMap<IMesh>)layers);
        for (class_2350 direction : DirectionUtils.FULL) {
            for (class_777 quad : this.method_4707(null, direction, randomSource)) {
                CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(quad.method_3359());
                if (culledMeshCollector == null) {
                    culledMeshCollector = new CulledMeshCollector(extension);
                    culledMeshCollectors.put(quad.method_3359(), (Object)culledMeshCollector);
                }
                class_4588 meshBuilder = extension.decorate(culledMeshCollector);
                int[] data = quad.method_3357();
                for (int i = 0; i < data.length / 8; ++i) {
                    int vertexOffset = i * IQuadTransformer.STRIDE;
                    int posOffset = vertexOffset + IQuadTransformer.POSITION;
                    int colorOffset = vertexOffset + IQuadTransformer.COLOR;
                    int uv0Offset = vertexOffset + IQuadTransformer.UV0;
                    int uv2Offset = vertexOffset + IQuadTransformer.UV2;
                    int normalOffset = vertexOffset + IQuadTransformer.NORMAL;
                    int packedNormal = data[normalOffset];
                    int packedColor = data[colorOffset];
                    float normalX = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
                    float normalY = (float)((byte)(packedNormal >> 8 & 0xFF)) / 127.0f;
                    float normalZ = (float)((byte)(packedNormal >> 16 & 0xFF)) / 127.0f;
                    if (normalX == 0.0f && normalY == 0.0f && normalZ == 0.0f) {
                        normalX = quad.method_3358().method_10163().method_10263();
                        normalY = quad.method_3358().method_10163().method_10264();
                        normalZ = quad.method_3358().method_10163().method_10260();
                    }
                    meshBuilder.method_23919(Float.intBitsToFloat(data[posOffset + 0]), Float.intBitsToFloat(data[posOffset + 1]), Float.intBitsToFloat(data[posOffset + 2]), (float)class_5253.class_8045.method_48345((int)packedColor) / 255.0f, (float)class_5253.class_8045.method_48346((int)packedColor) / 255.0f, (float)class_5253.class_8045.method_48347((int)packedColor) / 255.0f, (float)class_5253.class_8045.method_48342((int)packedColor) / 255.0f, Float.intBitsToFloat(data[uv0Offset + 0]), Float.intBitsToFloat(data[uv0Offset + 1]), -1, data[uv2Offset], normalX, normalY, normalZ);
                }
            }
        }
        IntIterator intIterator = culledMeshCollectors.keySet().iterator();
        while (intIterator.hasNext()) {
            int layer = (Integer)intIterator.next();
            CulledMeshCollector culledMeshCollector = (CulledMeshCollector)culledMeshCollectors.get(layer);
            culledMeshCollector.flush();
            IMeshData data = culledMeshCollector.getData();
            ByteBufferBuilder buffer = culledMeshCollector.getBuffer();
            IMesh mesh = this.merges.get(data);
            if (mesh != null) {
                buffer.close();
            } else {
                mesh = AcceleratedEntityRenderingFeature.getMeshType().getBuilder().build(culledMeshCollector);
            }
            layers.put(layer, (Object)mesh);
            this.merges.put(data, mesh);
            mesh.write(extension, this.getCustomColor(layer, layerColors.getColor(layer)), light, overlay);
        }
        extension.endTransform();
    }

    @Override
    @Unique
    public boolean isAccelerated() {
        return true;
    }

    @Override
    @Unique
    public boolean isAcceleratedInHand() {
        return false;
    }

    @Override
    @Unique
    public boolean isAcceleratedInGui() {
        return false;
    }

    @Override
    @Unique
    public int getCustomColor(int layer, int color) {
        return layer == -1 ? -1 : color;
    }
}

