/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.api;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusImpl
implements IEventBus {
    private final Logger logger = LoggerFactory.getLogger((String)"EventBusImpl");
    private final Multimap<EventPriority, EventHandler> eventHandlers = MultimapBuilder.hashKeys().arrayListValues().build();
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();

    @Override
    public <T> void register(Class<T> clazz) {
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            for (Annotation declaredAnnotation : declaredMethod.getDeclaredAnnotations()) {
                if (!(declaredAnnotation instanceof SubscribeEvent)) continue;
                SubscribeEvent subscribeEvent = (SubscribeEvent)declaredAnnotation;
                if (declaredMethod.getParameters().length != 1) continue;
                Class<?> paramType = declaredMethod.getParameters()[0].getType();
                try {
                    EventPriority phase = subscribeEvent.priority();
                    MethodHandle handle = this.lookup.unreflect(declaredMethod);
                    this.eventHandlers.put((Object)phase, (Object)new EventHandler(paramType, handle));
                }
                catch (Throwable throwable) {
                    this.logger.error("Could not register method {} as event handler.", (Object)declaredMethod, (Object)throwable);
                }
            }
        }
    }

    @Override
    public void post(EventPriority phase, Event event) {
        for (EventHandler eventHandler : this.eventHandlers.get((Object)phase)) {
            if (event.getClass() != eventHandler.eventType) continue;
            try {
                eventHandler.mt.invoke(event);
            }
            catch (Throwable e) {
                this.logger.error("An exception was thrown while posing event {} to {}.", new Object[]{e, eventHandler.mt, e});
            }
        }
    }

    private record EventHandler(Class<?> eventType, MethodHandle mt) {
    }
}

