package com.github.argon4w.acceleratedrendering.compat.iris.environments;

import com.github.argon4w.acceleratedrendering.core.backends.buffers.IServerBuffer;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.VertexFormatMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.programs.culling.LoadCullingProgramSelectorEvent;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.IPolygonProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.MeshUploadingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.dispatchers.TransformProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IShaderProgramOverrides;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.LoadShaderProgramOverridesEvent;
import com.github.argon4w.acceleratedrendering.core.programs.processing.IPolygonProcessor;
import com.github.argon4w.acceleratedrendering.core.programs.processing.LoadPolygonProcessorEvent;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_2960;
import net.neoforged.fml.ModLoader;

import java.util.Set;

public class IrisBufferEnvironment implements IBufferEnvironment {

	private final IBufferEnvironment vanillaSubSet;
	private final IBufferEnvironment irisSubSet;

	public IrisBufferEnvironment(
			IBufferEnvironment	vanillaSubSet,
			class_293		vanillaVertexFormat,
			class_293		irisVertexFormat,
			class_2960	meshUploadingProgramKey,
			class_2960	transformProgramKey
	) {
		this.vanillaSubSet	= vanillaSubSet;
		this.irisSubSet		= new IrisSubSet(
				vanillaVertexFormat,
				irisVertexFormat,
				meshUploadingProgramKey,
				transformProgramKey
		);
	}

	private IBufferEnvironment getSubSet() {
		return IrisApi.getInstance().isShaderPackInUse() && ImmediateState.isRenderingLevel ? irisSubSet : vanillaSubSet;
	}

	@Override
	public void setupBufferState() {
		getSubSet().setupBufferState();
	}

	@Override
	public Set<class_293> getVertexFormats() {
		return irisSubSet.getVertexFormats();
	}

	@Override
	public IMemoryLayout<class_296> getLayout() {
		return getSubSet().getLayout();
	}

	@Override
	public IServerBuffer getImmediateMeshBuffer() {
		return getSubSet().getImmediateMeshBuffer();
	}

	@Override
	public ITransformShaderProgramOverride getTransformProgramOverride(class_1921 renderType) {
		return getSubSet().getTransformProgramOverride(renderType);
	}

	@Override
	public IUploadingShaderProgramOverride getUploadingProgramOverride(class_1921 renderType) {
		return getSubSet().getUploadingProgramOverride(renderType);
	}

	@Override
	public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
		return getSubSet().selectMeshUploadingProgramDispatcher();
	}

	@Override
	public TransformProgramDispatcher selectTransformProgramDispatcher() {
		return getSubSet().selectTransformProgramDispatcher();
	}

	@Override
	public ICullingProgramDispatcher selectCullingProgramDispatcher(class_1921 renderType) {
		return getSubSet().selectCullingProgramDispatcher(renderType);
	}

	@Override
	public IPolygonProgramDispatcher selectProcessingProgramDispatcher(class_293.class_5596 mode) {
		return getSubSet().selectProcessingProgramDispatcher(mode);
	}

	@Override
	public boolean isAccelerated(class_293 vertexFormat) {
		return getSubSet().isAccelerated(vertexFormat);
	}

	@Override
	public int getVertexSize() {
		return getSubSet().getVertexSize();
	}

	public static class IrisSubSet implements IBufferEnvironment {

		private final class_293							vanillaVertexFormat;
		private final class_293							irisVertexFormat;
		private final IMemoryLayout<class_296>	layout;

		private final IShaderProgramOverrides				shaderProgramOverrides;
		private final MeshUploadingProgramDispatcher		meshUploadingProgramDispatcher;
		private final TransformProgramDispatcher			transformProgramDispatcher;
		private final ICullingProgramSelector				cullingProgramSelector;
		private final IPolygonProcessor						polygonProcessor;

		public IrisSubSet(
				class_293		vanillaVertexFormat,
				class_293		irisVertexFormat,
				class_2960	uploadingProgramKey,
				class_2960	transformProgramKey
		) {
			var defaultTransformOverride		= new TransformProgramDispatcher	.Default(transformProgramKey, 4L * 4L);
			var defaultUploadingOverride		= new MeshUploadingProgramDispatcher.Default(uploadingProgramKey, 7L * 4L);

			this.vanillaVertexFormat			= vanillaVertexFormat;
			this.irisVertexFormat				= irisVertexFormat;
			this.layout							= new VertexFormatMemoryLayout				(this.irisVertexFormat);

			this.shaderProgramOverrides			= ModLoader.postEventWithReturn				(new LoadShaderProgramOverridesEvent(this.irisVertexFormat)).getOverrides	(defaultTransformOverride, defaultUploadingOverride);
			this.cullingProgramSelector			= ModLoader.postEventWithReturn				(new LoadCullingProgramSelectorEvent(this.irisVertexFormat)).getSelector	();
			this.polygonProcessor				= ModLoader.postEventWithReturn				(new LoadPolygonProcessorEvent		(this.irisVertexFormat)).getProcessor	();

			this.meshUploadingProgramDispatcher	= new MeshUploadingProgramDispatcher		();
			this.transformProgramDispatcher		= new TransformProgramDispatcher			();
		}

		@Override
		public void setupBufferState() {
			irisVertexFormat.method_22649();
		}

		@Override
		public boolean isAccelerated(class_293 vertexFormat) {
			return this.vanillaVertexFormat == vertexFormat || this.irisVertexFormat == vertexFormat;
		}

		@Override
		public Set<class_293> getVertexFormats() {
			return Set.of(vanillaVertexFormat, irisVertexFormat);
		}

		@Override
		public IMemoryLayout<class_296> getLayout() {
			return layout;
		}

		@Override
		public IServerBuffer getImmediateMeshBuffer() {
			return ServerMesh.Builder.BUFFERS.get(layout).getFirst();
		}

		@Override
		public ITransformShaderProgramOverride getTransformProgramOverride(class_1921 renderType) {
			return shaderProgramOverrides.getTransformOverrides().get(renderType);
		}

		@Override
		public IUploadingShaderProgramOverride getUploadingProgramOverride(class_1921 renderType) {
			return shaderProgramOverrides.getUploadingOverrides().get(renderType);
		}

		@Override
		public MeshUploadingProgramDispatcher selectMeshUploadingProgramDispatcher() {
			return meshUploadingProgramDispatcher;
		}

		@Override
		public TransformProgramDispatcher selectTransformProgramDispatcher() {
			return transformProgramDispatcher;
		}

		@Override
		public ICullingProgramDispatcher selectCullingProgramDispatcher(class_1921 renderType) {
			return cullingProgramSelector.select(renderType);
		}

		@Override
		public IPolygonProgramDispatcher selectProcessingProgramDispatcher(class_293.class_5596 mode) {
			return polygonProcessor.select(mode);
		}

		@Override
		public int getVertexSize() {
			return irisVertexFormat.method_1362();
		}
	}
}
