package com.github.argon4w.acceleratedrendering.compat.iris.mixins.acceleratedrendering;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerDrawType;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import net.irisshaders.batchedentityrendering.impl.BlendingStateHolder;
import net.irisshaders.batchedentityrendering.impl.TransparencyType;
import net.irisshaders.batchedentityrendering.impl.WrappableRenderType;
import net.minecraft.class_1921;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(RenderTypeUtils.class)
public class RenderTypeUtilsMixin {

	@ModifyVariable(
			method		= "getTextureLocation",
			at			= @At("HEAD"),
			ordinal		= 0,
			argsOnly	= true
	)
	private static class_1921 unwrapIrisRenderType1(class_1921 renderType) {
		return renderType instanceof WrappableRenderType wrapped ? wrapped.unwrap() : renderType;
	}

	@ModifyVariable(
			method		= "isCulled",
			at			= @At("HEAD"),
			ordinal		= 0,
			argsOnly	= true
	)
	private static class_1921 unwrapIrisRenderType2(class_1921 renderType) {
		return renderType instanceof WrappableRenderType wrapped ? wrapped.unwrap() : renderType;
	}

	@Inject(
			method		= "getDrawType",
			at			= @At("HEAD"),
			cancellable	= true
	)
	private static void getIrisRenderTypeDrawType(class_1921 renderType, CallbackInfoReturnable<LayerDrawType> cir) {
		var holder = (BlendingStateHolder) renderType;

		cir.setReturnValue(	holder.getTransparencyType() == TransparencyType.GENERAL_TRANSPARENT
				||			holder.getTransparencyType() == TransparencyType.DECAL
				? LayerDrawType.TRANSLUCENT
				: LayerDrawType.OPAQUE
		);
	}
}
