package com.github.argon4w.acceleratedrendering.compat.iris.programs.culling;

import com.github.argon4w.acceleratedrendering.compat.iris.IrisCompatFeature;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import com.github.argon4w.acceleratedrendering.features.culling.OrientationCullingFeature;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class IrisCullingProgramSelector implements ICullingProgramSelector {

	private			final ICullingProgramSelector	parent;
	private			final ICullingProgramDispatcher	quadDispatcher;
	private			final ICullingProgramDispatcher	triangleDispatcher;

	public IrisCullingProgramSelector(
			ICullingProgramSelector	parent,
			class_2960		quadProgramKey,
			class_2960		triangleProgramKey
	) {
		this.parent				= parent;
		this.quadDispatcher		= new IrisCullingProgramDispatcher(class_293.class_5596.field_27382,		quadProgramKey);
		this.triangleDispatcher	= new IrisCullingProgramDispatcher(class_293.class_5596.field_27379,	triangleProgramKey);
	}

	@Override
	public ICullingProgramDispatcher select(class_1921 renderType) {
		if (			IrisCompatFeature			.isEnabled					()
				&&		IrisCompatFeature			.isIrisCompatCullingEnabled	()
				&&	(	IrisCompatFeature			.isShadowCullingEnabled		()	|| !	ShadowRenderingState.areShadowsCurrentlyBeingRendered())
				&&		OrientationCullingFeature	.isEnabled					()
				&&	(	OrientationCullingFeature	.shouldIgnoreCullState		()	|| 		RenderTypeUtils		.isCulled(renderType))
		) {
			return switch (renderType.field_20973) {
				case field_27382		-> quadDispatcher;
				case field_27379	-> triangleDispatcher;
				default			-> parent.select(renderType);
			};
		}

		return parent.select(renderType);
	}
}
