package com.github.argon4w.acceleratedrendering.core.backends.states.viewports;

import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.mojang.blaze3d.platform.GlStateManager;

public class MojangViewportBindingState implements IBindingState {

	private int viewportX;
	private int viewportY;
	private int viewportWidth;
	private int viewportHeight;

	public MojangViewportBindingState() {
		this.viewportX		= 0;
		this.viewportY		= 0;
		this.viewportWidth	= 0;
		this.viewportHeight	= 0;
	}

	@Override
	public void delete() {

	}

	@Override
	public void record() {
		viewportX		= GlStateManager.class_1040.method_35330		();
		viewportY		= GlStateManager.class_1040.method_35331		();
		viewportWidth	= GlStateManager.class_1040.method_35332	();
		viewportHeight	= GlStateManager.class_1040.method_35333();
	}

	@Override
	public void restore() {
		if (		viewportX		!= GlStateManager.class_1040.method_35330		()
				||	viewportY		!= GlStateManager.class_1040.method_35331		()
				||	viewportWidth	!= GlStateManager.class_1040.method_35332	()
				||	viewportHeight	!= GlStateManager.class_1040.method_35333	()
		) {
			GlStateManager._viewport(
					viewportX,
					viewportY,
					viewportWidth,
					viewportHeight
			);
		}
	}
}
