package com.github.argon4w.acceleratedrendering.core.buffers;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.IAcceleratedBufferSource;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedBufferBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_293;

public class AcceleratedBufferSources implements IAcceleratedBufferSource {

	private final Map<class_293, AcceleratedBufferSource>	sources;
	private final Set<class_293.class_5596>						validModes;
	private final Set<String>									dynamicNames;
	private final boolean										canSort;
	private final boolean										canScroll;

	private AcceleratedBufferSources(
			Map<class_293, AcceleratedBufferSource>	sources,
			Set<class_293.class_5596>						validModes,
			Set<String>									dynamicNames,
			boolean										canSort,
			boolean										canScroll
	) {
		this.sources		= sources;
		this.validModes		= validModes;
		this.dynamicNames	= dynamicNames;
		this.canSort		= canSort;
		this.canScroll		= canScroll;
	}

	@Override
	public AcceleratedBufferBuilder getBuffer(
			class_1921	renderType,
			Runnable	before,
			Runnable	after,
			int			layer
	) {
		if (			renderType		!= null
				&& 	(	CoreFeature		.shouldForceAccelerateTranslucent	()	|| canSort		|| !						renderType.field_21402)
				&& 	(	CoreFeature		.shouldCacheDynamicRenderType		()	|| canScroll	|| !dynamicNames.contains(	renderType.field_21363))
				&&		validModes		.contains							(renderType.field_20973)
				&&		sources			.containsKey						(renderType.field_20972)
		) {
			return sources
					.get		(renderType.field_20972)
					.getBuffer	(
							renderType,
							before,
							after,
							layer
					);
		}

		return null;
	}

	public static Builder builder() {
		return new Builder();
	}

	public static class Builder {

		private final	Map<class_293, AcceleratedBufferSource>	sources;
		private final	Set<class_293.class_5596>						validModes;
		private final	Set<String>									dynamicNames;

		private			boolean										canSort;
		private			boolean										canScroll;

		private Builder() {
			this.sources		= new Reference2ObjectOpenHashMap	<>();
			this.validModes		= new ReferenceOpenHashSet			<>();
			this.dynamicNames	= new ObjectOpenHashSet				<>();

			this.canSort		= false;
			this.canScroll		= false;
		}

		public Builder source(AcceleratedBufferSource bufferSource) {
			for (var format : bufferSource
					.getEnvironment		()
					.getVertexFormats	()
			) {
				sources.put(format, bufferSource);
			}

			return this;
		}

		public Builder mode(class_293.class_5596 mode) {
			validModes.add(mode);
			return this;
		}

		public Builder dynamic(String name) {
			dynamicNames.add(name);
			return this;
		}

		public Builder canSort() {
			canSort = true;
			return this;
		}

		public Builder canScroll() {
			canScroll = true;
			return this;
		}

		public AcceleratedBufferSources build() {
			return new AcceleratedBufferSources(
					sources,
					validModes,
					dynamicNames,
					canSort,
					canScroll
			);
		}
	}
}
