package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers;

import lombok.AllArgsConstructor;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@AllArgsConstructor
public class DecoratedRenderer<T> implements IAcceleratedRenderer<T> {

	private final IAcceleratedRenderer<T>	renderer;
	private final IBufferDecorator			bufferDecorator;

	@Override
	public void render(
			class_4588	vertexConsumer,
			T				context,
			Matrix4f		transform,
			Matrix3f		normal,
			int				light,
			int				overlay,
			int				color
	) {
		renderer.render(
				bufferDecorator.decorate(vertexConsumer),
				context,
				transform,
				normal,
				light,
				overlay,
				color
		);
	}
}
