package com.github.argon4w.acceleratedrendering.core.buffers.memory;

import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatMemoryLayout implements IMemoryLayout<class_296> {

	private final int					mask;
	private final long					size;
	private final IMemoryInterface	[]	byId;
	private final int				[]	offsets;

	public VertexFormatMemoryLayout(class_293 vertexFormat) {
		var offsets		= vertexFormat	.method_60838();
		var count		= offsets		.length;

		this.mask		= vertexFormat	.method_60839();
		this.size		= vertexFormat	.method_1362	();
		this.byId		= new IMemoryInterface			[count];
		this.offsets	= new int						[count];

		for (var i = 0; i < count; i ++) {
			var offset		= offsets[i];
			this.byId	[i]	= offset == -1 ? NullMemoryInterface.INSTANCE : new SimpleMemoryInterface(offset, size);
			this.offsets[i]	= offset;
		}
	}

	@Override
	public IMemoryInterface getElement(class_296 element) {
		return byId[element.comp_2842()];
	}

	@Override
	public int getElementOffset(class_296 element) {
		return offsets[element.comp_2842()];
	}

	@Override
	public boolean containsElement(class_296 element) {
		return (mask & element.method_60843()) != 0;
	}

	@Override
	public long getSize() {
		return size;
	}
}
