package com.github.argon4w.acceleratedrendering.core.meshes.identity;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import net.minecraft.class_296;

public enum MeshMergeType {

	IGNORED,
	MERGED;

	public IMeshData create(IMemoryLayout<class_296> layout) {
		return create(this, layout);
	}

	public static IMeshData create(MeshMergeType type, IMemoryLayout<class_296> layout) {
		return switch (type) {
			case IGNORED	-> new IdentityMeshData	();
			case MERGED		-> new SimpleMeshData	(layout);
		};
	}
}
