package com.github.argon4w.acceleratedrendering.core.mixins.buffers;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.AcceleratedSpriteCoordinateExpander;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.DecoratedRenderer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1058;
import net.minecraft.class_4588;
import net.minecraft.class_4723;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@ExtensionMethod(VertexConsumerExtension	.class)
@Mixin			(class_4723	.class)
public class SpriteCoordinateExpanderMixin implements IAcceleratedVertexConsumer {

	@Shadow @Final private class_4588		delegate;
	@Shadow @Final private class_1058	sprite;

	@Unique
	@Override
	public class_4588 decorate(class_4588 buffer) {
		return new AcceleratedSpriteCoordinateExpander(buffer, sprite);
	}

	@Unique
	@Override
	public boolean isAccelerated() {
		return delegate
				.getAccelerated	()
				.isAccelerated	();
	}

	@Unique
	@Override
	public <T>  void doRender(
			IAcceleratedRenderer<T>	renderer,
			T						context,
			Matrix4f				transform,
			Matrix3f				normal,
			int						light,
			int						overlay,
			int						color
	) {
		delegate
				.getAccelerated	()
				.doRender		(
						new DecoratedRenderer<>(renderer, this),
						context,
						transform,
						normal,
						light,
						overlay,
						color
				);
	}
}
