package com.github.argon4w.acceleratedrendering.core.mixins.compatibility;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.util.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

@Mixin(class_1921.class)
public class RenderTypeMixin {

	@Unique private static final Map<Pair<class_2960, Integer>, class_1921> ENERGY_SWIRL	= new ConcurrentHashMap<>();
	@Unique private static final Map<Pair<class_2960, Integer>, class_1921> BREEZE_WIND	= new ConcurrentHashMap<>();

	@WrapMethod(method = "energySwirl")
	private static class_1921 cacheEnergySwirl(
			class_2960		location,
			float					u,
			float					v,
			Operation<class_1921>	original
	) {
		return ENERGY_SWIRL.computeIfAbsent(Pair.of(location, CoreFeature.packDynamicUV(u, v)), pair -> original.call(
				location,
				CoreFeature.unpackDynamicU(pair.getSecond()),
				CoreFeature.unpackDynamicV(pair.getSecond())
		));
	}

	@WrapMethod(method = "breezeWind")
	private static class_1921 cacheBreezeWind(
			class_2960		location,
			float					u,
			float					v,
			Operation<class_1921>	original
	) {
		return BREEZE_WIND.computeIfAbsent(Pair.of(location, CoreFeature.packDynamicUV(u, v)), pair -> original.call(
				location,
				CoreFeature.unpackDynamicU(pair.getSecond()),
				CoreFeature.unpackDynamicV(pair.getSecond())
		));
	}
}
