package com.github.argon4w.acceleratedrendering.core.programs.processing;

import lombok.Getter;
import net.minecraft.class_293;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

import java.util.function.UnaryOperator;

public class LoadPolygonProcessorEvent extends Event implements IModBusEvent {

	private final	class_293		vertexFormat;

	@Getter private IPolygonProcessor	processor;

	public LoadPolygonProcessorEvent(class_293 vertexFormat) {
		this.vertexFormat	= vertexFormat;
		this.processor		= EmptyPolygonProcessor.INSTANCE;
	}

	public void loadFor(class_293 vertexFormat, UnaryOperator<IPolygonProcessor> selector) {
		if (this.vertexFormat == vertexFormat) {
			this.processor = selector.apply(this.processor);
		}
	}
}
