package com.github.argon4w.acceleratedrendering.features.filter;

import com.github.argon4w.acceleratedrendering.configs.FeatureConfig;
import com.github.argon4w.acceleratedrendering.configs.FeatureStatus;
import com.github.argon4w.acceleratedrendering.core.utils.RegistryFilter;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public class FilterFeature {

	private	static final Deque	<FeatureStatus>			ENTITIES_FILTER_CONTROLLER_STACK		= new ArrayDeque<>();
	private	static final Deque	<FeatureStatus>			BLOCK_ENTITIES_FILTER_CONTROLLER_STACK	= new ArrayDeque<>();
	private	static final Deque	<FeatureStatus>			ITEM_FILTER_CONTROLLER_STACK			= new ArrayDeque<>();
	private static final Deque	<FeatureStatus>			STAGE_FILTER_CONTROLLER_STACK			= new ArrayDeque<>();

	private	static final Set	<class_1299<?>>			ENTITY_FILTER_VALUES;
	private	static final Set	<class_2591<?>>	BLOCK_ENTITY_FILTER_VALUES;
	private static final Set	<class_1792>					ITEM_FILTER_VALUES;
	private static final Set	<String>				STAGE_FILTER_VALUES;

	static {
		ENTITY_FILTER_VALUES		= RegistryFilter.filterValues	(class_7923.field_41177,			FeatureConfig.CONFIG.filterEntityFilterValues		.get());
		BLOCK_ENTITY_FILTER_VALUES	= RegistryFilter.filterValues	(class_7923.field_41181,	FeatureConfig.CONFIG.filterBlockEntityFilterValues	.get());
		ITEM_FILTER_VALUES			= RegistryFilter.filterValues	(class_7923.field_41178,				FeatureConfig.CONFIG.filterItemFilterValues			.get());
		STAGE_FILTER_VALUES			= new ReferenceOpenHashSet<>	(										FeatureConfig.CONFIG.filterStageFilterValues		.get());
	}

	public static boolean isEnabled() {
		return FeatureConfig.CONFIG.filterFeatureStatus.get() == FeatureStatus.ENABLED;
	}

	public static boolean testEntity(class_1297 entity) {
		return getEntityFilterType().test(ENTITY_FILTER_VALUES, entity.method_5864());
	}

	public static boolean testBlockEntity(class_2586 entity) {
		return getBlockEntityFilterType().test(BLOCK_ENTITY_FILTER_VALUES, entity.method_11017());
	}

	public static boolean testItem(class_1799 itemStack) {
		return getItemFilterType().test(ITEM_FILTER_VALUES, itemStack.method_7909());
	}

//	public static boolean testStage(RenderLevelStageEvent.Stage stage) {
//		return getStageFilterType().test(STAGE_FILTER_VALUES, stage.toString());
//	}

	public static boolean shouldFilterEntities() {
		return getEntityFilterSetting() == FeatureStatus.ENABLED;
	}

	public static boolean shouldFilterBlockEntities() {
		return getBlockEntityFilterSetting() == FeatureStatus.ENABLED;
	}

	public static boolean shouldFilterItems() {
		return getItemFilterSetting() == FeatureStatus.ENABLED;
	}

	public static boolean shouldFilterStage() {
		return getStageFilterSetting() == FeatureStatus.ENABLED;
	}

	public static FilterType getEntityFilterType() {
		return FeatureConfig.CONFIG.filterEntityFilterType.get();
	}

	public static FilterType getBlockEntityFilterType() {
		return FeatureConfig.CONFIG.filterBlockEntityFilterType.get();
	}

	public static FilterType getItemFilterType() {
		return FeatureConfig.CONFIG.filterItemFilterType.get();
	}

	public static FilterType getStageFilterType() {
		return FeatureConfig.CONFIG.filterStageFilterType.get();
	}

	public static void disableEntityFilter() {
		ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
	}

	public static void disableBlockEntityFilter() {
		BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
	}

	public static void disableItemFilter() {
		ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
	}

	public static void disableStageFilter() {
		STAGE_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
	}

	public static void forceEnableEntityFilter() {
		ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
	}

	public static void forceEnableBlockEntityFilter() {
		BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
	}

	public static void forceEnableItemFilter() {
		ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
	}

	public static void forceEnableStageFilter() {
		STAGE_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
	}

	public static void forceSetEntityFilter(FeatureStatus status) {
		ENTITIES_FILTER_CONTROLLER_STACK.push(status);
	}

	public static void forceSetBlockEntityFilter(FeatureStatus status) {
		BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(status);
	}

	public static void forceSetItemFilter(FeatureStatus status) {
		ITEM_FILTER_CONTROLLER_STACK.push(status);
	}

	public static void forceSetStageFilter(FeatureStatus status) {
		STAGE_FILTER_CONTROLLER_STACK.push(status);
	}

	public static void resetEntityFilter() {
		ENTITIES_FILTER_CONTROLLER_STACK.pop();
	}

	public static void resetBlockEntityFilter() {
		BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.pop();
	}

	public static void resetItemFilter() {
		ITEM_FILTER_CONTROLLER_STACK.pop();
	}

	public static void resetStageFilter() {
		STAGE_FILTER_CONTROLLER_STACK.pop();
	}

	public static FeatureStatus getEntityFilterSetting() {
		return ENTITIES_FILTER_CONTROLLER_STACK.isEmpty() ? getDefaultEntityFilterSetting() : ENTITIES_FILTER_CONTROLLER_STACK.peek();
	}

	public static FeatureStatus getBlockEntityFilterSetting() {
		return BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.isEmpty() ? getDefaultBlockEntityFilterSetting() : BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.peek();
	}

	public static FeatureStatus getItemFilterSetting() {
		return ITEM_FILTER_CONTROLLER_STACK.isEmpty() ? getDefaultItemFilterSetting() : ITEM_FILTER_CONTROLLER_STACK.peek();
	}

	public static FeatureStatus getStageFilterSetting() {
		return STAGE_FILTER_CONTROLLER_STACK.isEmpty() ? getDefaultStageFilterSetting() : STAGE_FILTER_CONTROLLER_STACK.peek();
	}

	public static FeatureStatus getDefaultEntityFilterSetting() {
		return FeatureConfig.CONFIG.filterEntityFilter.get();
	}

	public static FeatureStatus getDefaultBlockEntityFilterSetting() {
		return FeatureConfig.CONFIG.filterBlockEntityFilter.get();
	}

	public static FeatureStatus getDefaultItemFilterSetting() {
		return FeatureConfig.CONFIG.filterItemFilter.get();
	}

	public static FeatureStatus getDefaultStageFilterSetting() {
		return FeatureConfig.CONFIG.filterStageFilter.get();
	}
}
