package com.github.argon4w.acceleratedrendering.features.items.gui;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.backends.states.FramebufferBindingState;
import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.github.argon4w.acceleratedrendering.core.utils.SimpleTextureTarget;
import com.github.argon4w.acceleratedrendering.features.items.AcceleratedItemRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedGuiGraphics;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class GuiBatchingController {

	public static	final GuiBatchingController		INSTANCE = new GuiBatchingController();

	private			final class_1041					window;
	private			final IBindingState				viewport;
	private			final FramebufferBindingState	binding;
	private			final class_276				overlay;

	private GuiBatchingController() {
		this.window		= class_310.method_1551()	.method_22683				();
		this.viewport	= CoreFeature				.createViewportState	();
		this.binding	= new FramebufferBindingState						();
		this.overlay	= new SimpleTextureTarget							(true);
	}

	public void startBatching() {
		if (		AcceleratedItemRenderingFeature	.isEnabled					()
				&&	AcceleratedItemRenderingFeature	.shouldAccelerateInGui		()
				&&	AcceleratedItemRenderingFeature	.shouldUseGuiItemBatching	()
				&&	CoreFeature						.isLoaded					()
		) {
			CoreFeature.setGuiBatching();
		}
	}

	public void flushBatching(class_332 graphics) {
		if (CoreFeature.isGuiBatching()) {
			CoreFeature							.resetGuiBatching	();
			((IAcceleratedGuiGraphics) graphics).flushItemBatching	();

			RenderSystem.enableBlend		();
			RenderSystem.blendFuncSeparate	(
					GlStateManager.class_4535	.SRC_ALPHA,
					GlStateManager.class_4534	.ONE_MINUS_SRC_ALPHA,
					GlStateManager.class_4535	.ZERO,
					GlStateManager.class_4534	.ONE
			);

			overlay.method_22594(
					window.method_4489	(),
					window.method_4506(),
					false
			);

			RenderSystem.disableBlend		();
			RenderSystem.defaultBlendFunc	();
			binding		.record				();
			overlay		.method_1230				(class_310.field_1703);
			binding		.restore			();
		}
	}

	public void resize(
			int		newWidth,
			int		newHeight,
			boolean	clearError
	) {
		overlay.method_1234(
				newWidth,
				newHeight,
				clearError
		);
	}

	public void useOverlayTarget() {
		if (CoreFeature.isGuiBatching()) {
			viewport.record		();
			binding	.record		();
			overlay	.method_1235	(false);
		}
	}

	public void resetOverlayTarget() {
		if (CoreFeature.isGuiBatching()) {
			overlay	.method_1240();
			binding	.restore	();
			viewport.restore	();
		}
	}
}
