package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.CulledMeshCollector;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.DirectionUtils;
import com.github.argon4w.acceleratedrendering.features.entities.AcceleratedEntityRenderingFeature;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import com.github.argon4w.acceleratedrendering.features.items.colors.FixedColors;
import com.github.argon4w.acceleratedrendering.features.items.colors.ItemLayerColors;
import com.github.argon4w.acceleratedrendering.features.items.contexts.AcceleratedModelRenderContext;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1093;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import java.util.Map;

@ExtensionMethod(VertexConsumerExtension.class)
@Mixin			(class_1093		.class)
public abstract class SimpleBakedModelMixin implements IAcceleratedBakedModel, IAcceleratedRenderer<AcceleratedModelRenderContext> {

	@Shadow public abstract List<class_777> getQuads(class_2680 pState, class_2350 pDirection, class_5819 pRandom);

	@Unique private final Map<IBufferGraph,	Int2ObjectMap<IMesh>>	meshes = new Object2ObjectOpenHashMap<>();
	@Unique private final Map<IMeshData,	IMesh>					merges = new Object2ObjectOpenHashMap<>();

	@Unique
	@Override
	public void renderItemFast(
			class_1799					itemStack,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							combinedLight,
			int							combinedOverlay
	) {
		extension.doRender(
				this,
				new AcceleratedModelRenderContext(random, new ItemLayerColors(itemStack)),
				pose.method_23761	(),
				pose.method_23762	(),
				combinedLight,
				combinedOverlay,
				-1
		);
	}

	@Override
	public void renderBlockFast(
			class_2680					state,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							combinedLight,
			int							combinedOverlay,
			int							color
	) {
		extension.doRender(
				this,
				new AcceleratedModelRenderContext(random, new FixedColors(color)),
				pose.method_23761	(),
				pose.method_23762	(),
				combinedLight,
				combinedOverlay,
				-1
		);
	}

	@Unique
	@Override
	public void render(
			class_4588					vertexConsumer,
			AcceleratedModelRenderContext	context,
			Matrix4f						transform,
			Matrix3f						normal,
			int								light,
			int								overlay,
			int								color
	) {
		var extension		= vertexConsumer.getAccelerated	();
		var randomSource	= context		.randomSource	();
		var layerColors		= context		.layerColors	();
		var layers			= meshes		.get			(extension);

		extension.beginTransform(transform, normal);

		if (layers != null) {
			for (int layer : layers.keySet()) {
				var mesh = layers.get(layer);

				mesh.write(
						extension,
						getCustomColor(layer, layerColors.getColor(layer)),
						light,
						overlay
				);
			}

			extension.endTransform();
			return;
		}

		var culledMeshCollectors	= new Int2ObjectOpenHashMap	<CulledMeshCollector>	();
		layers 						= new Int2ObjectAVLTreeMap	<>						();

		meshes.put(extension, layers);

		for (var direction : DirectionUtils.FULL) {
			for (var quad : getQuads(
					null,
					direction,
					randomSource
			)) {
				var culledMeshCollector = culledMeshCollectors.get(quad.method_3359());

				if (culledMeshCollector == null) {
					culledMeshCollector = new CulledMeshCollector	(extension);
					culledMeshCollectors.put						(quad.method_3359(), culledMeshCollector);
				}

				var meshBuilder = extension	.decorate	(culledMeshCollector);
				var data		= quad		.method_3357();

				for (int i = 0; i < data.length / 8; i++) {
					var vertexOffset	= i				* IQuadTransformer.STRIDE;
					var posOffset		= vertexOffset	+ IQuadTransformer.POSITION;
					var colorOffset		= vertexOffset	+ IQuadTransformer.COLOR;
					var uv0Offset		= vertexOffset	+ IQuadTransformer.UV0;
					var uv2Offset		= vertexOffset	+ IQuadTransformer.UV2;
					var normalOffset	= vertexOffset	+ IQuadTransformer.NORMAL;
					var packedNormal	= data[normalOffset];

                    float normalX = ((byte) (packedNormal & 0xFF)) / 127.0f;
                    float normalY = ((byte) ((packedNormal >> 8) & 0xFF)) / 127.0f;
                    float normalZ = ((byte) ((packedNormal >> 16) & 0xFF)) / 127.0f;

                    if (normalX == 0 && normalY == 0 && normalZ == 0) {
                        normalX = quad.method_3358().method_10163().method_10263();
                        normalY = quad.method_3358().method_10163().method_10264();
                        normalZ = quad.method_3358().method_10163().method_10260();
                    }

					meshBuilder.addVertex(
							Float.intBitsToFloat(data[posOffset + 0]),
							Float.intBitsToFloat(data[posOffset + 1]),
							Float.intBitsToFloat(data[posOffset + 2]),
							data[colorOffset],
							Float.intBitsToFloat(data[uv0Offset + 0]),
							Float.intBitsToFloat(data[uv0Offset + 1]),
							-1,
							data[uv2Offset],
                        	normalX,
                        	normalY,
                        	normalZ
					);
				}
			}
		}

		for (int layer : culledMeshCollectors.keySet()) {
			var culledMeshCollector = culledMeshCollectors.get(layer);

			culledMeshCollector.flush();

			var data	= culledMeshCollector	.getData	();
			var buffer	= culledMeshCollector	.getBuffer	();
			var mesh	= merges				.get		(data);

			if (mesh != null) {
				buffer.method_60811	();
				buffer.close	();
			} else {
				mesh = AcceleratedEntityRenderingFeature
						.getMeshType()
						.getBuilder	()
						.build		(culledMeshCollector);
			}

			layers	.put	(layer, mesh);
			merges	.put	(data,	mesh);
			mesh	.write	(
					extension,
					getCustomColor(layer, layerColors.getColor(layer)),
					light,
					overlay
			);
		}

		extension.endTransform();
	}


	@Unique
	@Override
	public boolean isAccelerated() {
		return true;
	}

	@Unique
	@Override
	public boolean isAcceleratedInHand() {
		return false;
	}

	@Unique
	@Override
	public boolean isAcceleratedInGui() {
		return false;
	}

	@Unique
	@Override
	public int getCustomColor(int layer, int color) {
		return layer == -1 ? -1 : color;
	}
}
