/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.neoforged.neoforge.client.model;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_290;
import net.minecraft.class_296;
import net.minecraft.class_777;

/**
 * Transformer for {@link class_777 baked quads}.
 *
 * @see QuadTransformers
 */
public interface IQuadTransformer {
    int STRIDE = class_290.field_1590.method_1362() / 4;
    int POSITION = findOffset(class_296.field_52107);
    int COLOR = findOffset(class_296.field_52108);
    int UV0 = findOffset(class_296.field_52109);
    int UV1 = findOffset(class_296.field_52111);
    int UV2 = findOffset(class_296.field_52112);
    int NORMAL = findOffset(class_296.field_52113);

    void processInPlace(class_777 quad);

    default void processInPlace(List<class_777> quads) {
        for (class_777 quad : quads)
            processInPlace(quad);
    }

    private static int findOffset(class_296 element) {
        if (class_290.field_1590.method_60836(element)) {
            // Divide by 4 because we want the int offset
            return class_290.field_1590.method_60835(element) / 4;
        }
        return -1;
    }
}
