/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core;

import com.github.argon4w.acceleratedrendering.configs.FeatureConfig;
import com.github.argon4w.acceleratedrendering.configs.FeatureStatus;
import com.github.argon4w.acceleratedrendering.core.backends.states.IBindingState;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.BlockBufferBindingStateType;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.BufferBlockType;
import com.github.argon4w.acceleratedrendering.core.backends.states.buffers.cache.BlockBufferBindingCacheType;
import com.github.argon4w.acceleratedrendering.core.backends.states.viewports.ViewportBindingStateType;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.ILayerStorage;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.storage.LayerStorageType;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.IMeshInfoCache;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshInfoCacheType;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.IMeshData;
import com.github.argon4w.acceleratedrendering.core.meshes.identity.MeshMergeType;
import com.github.argon4w.acceleratedrendering.core.programs.ComputeShaderProgramLoader;
import com.github.argon4w.acceleratedrendering.core.utils.PackedVector2i;
import com.google.common.util.concurrent.Runnables;
import java.util.ArrayDeque;
import net.minecraft.class_296;

public class CoreFeature {
    private static final ArrayDeque<FeatureStatus> FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK = new ArrayDeque();
    private static final ArrayDeque<FeatureStatus> CACHE_IDENTICAL_POSE_CONTROLLER_STACK = new ArrayDeque();
    private static final ArrayDeque<Integer> DEFAULT_LAYER_CONTROLLER_STACK = new ArrayDeque();
    private static final ArrayDeque<Runnable> DEFAULT_LAYER_BEFORE_FUNCTION_CONTROLLER_STACK = new ArrayDeque();
    private static final ArrayDeque<Runnable> DEFAULT_LAYER_AFTER_FUNCTION_CONTROLLER_STACK = new ArrayDeque();
    private static boolean RENDERING_LEVEL = false;
    private static boolean RENDERING_HAND = false;
    private static boolean RENDERING_GUI = false;
    private static boolean GUI_BATCHING = false;

    public static boolean isLoaded() {
        return ComputeShaderProgramLoader.isProgramsLoaded();
    }

    public static boolean isDebugContextEnabled() {
        return FeatureConfig.CONFIG.coreDebugContextEnabled.get() == FeatureStatus.ENABLED;
    }

    public static int getPooledRingBufferSize() {
        return FeatureConfig.CONFIG.corePooledRingBufferSize.getAsInt();
    }

    public static int getPooledBatchingSize() {
        return FeatureConfig.CONFIG.corePooledBatchingSize.getAsInt();
    }

    public static int getCachedImageSize() {
        return FeatureConfig.CONFIG.coreCachedImageSize.getAsInt();
    }

    public static float getDynamicUVResolution() {
        return FeatureConfig.CONFIG.coreDynamicUVResolution.getAsInt();
    }

    public static boolean shouldForceAccelerateTranslucent() {
        return CoreFeature.getForceTranslucentAccelerationSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldCacheIdenticalPose() {
        return CoreFeature.getCacheIdenticalPoseSetting() == FeatureStatus.ENABLED;
    }

    public static MeshInfoCacheType getMeshInfoCacheType() {
        return (MeshInfoCacheType)((Object)FeatureConfig.CONFIG.coreMeshInfoCacheType.get());
    }

    public static LayerStorageType getLayerStorageType() {
        return (LayerStorageType)((Object)FeatureConfig.CONFIG.coreLayerStorageType.get());
    }

    public static MeshMergeType getMeshMergeType() {
        return (MeshMergeType)((Object)FeatureConfig.CONFIG.coreMeshMergeType.get());
    }

    public static boolean shouldUploadMeshImmediately() {
        return FeatureConfig.CONFIG.coreUploadMeshImmediately.get() == FeatureStatus.ENABLED;
    }

    public static boolean shouldCacheDynamicRenderType() {
        return FeatureConfig.CONFIG.coreCacheDynamicRenderType.get() == FeatureStatus.ENABLED;
    }

    public static boolean shouldRestoreBlockBuffers() {
        return FeatureConfig.CONFIG.restoringFeatureStatus.get() == FeatureStatus.ENABLED;
    }

    public static BlockBufferBindingCacheType getBlockBufferBindingCacheType() {
        return (BlockBufferBindingCacheType)((Object)FeatureConfig.CONFIG.restoringBindingCacheType.get());
    }

    public static BlockBufferBindingStateType getShaderStorageStateType() {
        return (BlockBufferBindingStateType)((Object)FeatureConfig.CONFIG.restoringShaderStorageType.get());
    }

    public static ViewportBindingStateType getViewportBindingStateType() {
        return (ViewportBindingStateType)((Object)FeatureConfig.CONFIG.coreViewportBindingType.get());
    }

    public static BlockBufferBindingStateType getAtomicCounterStateType() {
        return (BlockBufferBindingStateType)((Object)FeatureConfig.CONFIG.restoringAtomicCounterType.get());
    }

    public static int getShaderStorageRestoringRange() {
        return FeatureConfig.CONFIG.restoringShaderStorageRange.getAsInt();
    }

    public static int getAtomicCounterRestoringRange() {
        return FeatureConfig.CONFIG.restoringAtomicCounterRange.getAsInt();
    }

    public static IMeshInfoCache createMeshInfoCache() {
        return CoreFeature.getMeshInfoCacheType().create();
    }

    public static ILayerStorage createLayerStorage() {
        return CoreFeature.getLayerStorageType().create(CoreFeature.getPooledBatchingSize());
    }

    public static IMeshData createMeshData(IMemoryLayout<class_296> layout) {
        return CoreFeature.getMeshMergeType().create(layout);
    }

    public static IBindingState createViewportState() {
        return CoreFeature.getViewportBindingStateType().create();
    }

    public static IBindingState createShaderStorageState() {
        return CoreFeature.getShaderStorageStateType().create(CoreFeature.getBlockBufferBindingCacheType(), BufferBlockType.SHADER_STORAGE, CoreFeature.getShaderStorageRestoringRange());
    }

    public static IBindingState createAtomicCounterState() {
        return CoreFeature.getAtomicCounterStateType().create(CoreFeature.getBlockBufferBindingCacheType(), BufferBlockType.ATOMIC_COUNTER, CoreFeature.getAtomicCounterRestoringRange());
    }

    public static int packDynamicUV(float u, float v) {
        return PackedVector2i.pack(u * CoreFeature.getDynamicUVResolution(), v * CoreFeature.getDynamicUVResolution());
    }

    public static float unpackDynamicU(int packedUV) {
        return (float)PackedVector2i.unpackU(packedUV) / CoreFeature.getDynamicUVResolution();
    }

    public static float unpackDynamicV(int packedUV) {
        return (float)PackedVector2i.unpackV(packedUV) / CoreFeature.getDynamicUVResolution();
    }

    public static void disableForceTranslucentAcceleration() {
        FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableCacheIdenticalPose() {
        CACHE_IDENTICAL_POSE_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void forceEnableForceTranslucentAcceleration() {
        FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableCacheIdenticalPose() {
        CACHE_IDENTICAL_POSE_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceSetForceTranslucentAcceleration(FeatureStatus status) {
        FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.push(status);
    }

    public static void forceSetCacheIdenticalPose(FeatureStatus status) {
        CACHE_IDENTICAL_POSE_CONTROLLER_STACK.push(status);
    }

    public static void forceSetDefaultLayer(int defaultLayer) {
        DEFAULT_LAYER_CONTROLLER_STACK.push(defaultLayer);
    }

    public static void forceSetDefaultLayerBeforeFunction(Runnable runnable) {
        DEFAULT_LAYER_BEFORE_FUNCTION_CONTROLLER_STACK.push(runnable);
    }

    public static void forceSetDefaultLayerAfterFunction(Runnable runnable) {
        DEFAULT_LAYER_AFTER_FUNCTION_CONTROLLER_STACK.push(runnable);
    }

    public static void resetForceTranslucentAcceleration() {
        FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.pop();
    }

    public static void resetCacheIdenticalPose() {
        CACHE_IDENTICAL_POSE_CONTROLLER_STACK.pop();
    }

    public static void resetDefaultLayer() {
        DEFAULT_LAYER_CONTROLLER_STACK.pop();
    }

    public static void resetDefaultLayerBeforeFunction() {
        DEFAULT_LAYER_BEFORE_FUNCTION_CONTROLLER_STACK.pop();
    }

    public static void resetDefaultLayerAfterFunction() {
        DEFAULT_LAYER_AFTER_FUNCTION_CONTROLLER_STACK.pop();
    }

    public static FeatureStatus getForceTranslucentAccelerationSetting() {
        return FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.isEmpty() ? CoreFeature.getDefaultForceTranslucentAccelerationSetting() : FORCE_TRANSLUCENT_ACCELERATION_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getCacheIdenticalPoseSetting() {
        return CACHE_IDENTICAL_POSE_CONTROLLER_STACK.isEmpty() ? CoreFeature.getDefaultCacheIdenticalPoseSetting() : CACHE_IDENTICAL_POSE_CONTROLLER_STACK.peek();
    }

    public static int getDefaultLayer() {
        return DEFAULT_LAYER_CONTROLLER_STACK.isEmpty() ? 0 : DEFAULT_LAYER_CONTROLLER_STACK.peek();
    }

    public static Runnable getDefaultLayerBeforeFunction() {
        return DEFAULT_LAYER_BEFORE_FUNCTION_CONTROLLER_STACK.isEmpty() ? Runnables.doNothing() : DEFAULT_LAYER_BEFORE_FUNCTION_CONTROLLER_STACK.peek();
    }

    public static Runnable getDefaultLayerAfterFunction() {
        return DEFAULT_LAYER_AFTER_FUNCTION_CONTROLLER_STACK.isEmpty() ? Runnables.doNothing() : DEFAULT_LAYER_AFTER_FUNCTION_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getDefaultForceTranslucentAccelerationSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.coreForceTranslucentAcceleration.get());
    }

    public static FeatureStatus getDefaultCacheIdenticalPoseSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.coreCacheIdenticalPose.get());
    }

    public static void setRenderingLevel() {
        RENDERING_LEVEL = true;
    }

    public static void resetRenderingLevel() {
        RENDERING_LEVEL = false;
    }

    public static void setRenderingHand() {
        RENDERING_HAND = true;
    }

    public static void resetRenderingHand() {
        RENDERING_HAND = false;
    }

    public static void setRenderingGui() {
        RENDERING_GUI = true;
    }

    public static void resetRenderingGui() {
        RENDERING_GUI = false;
    }

    public static boolean isRenderingLevel() {
        return RENDERING_LEVEL;
    }

    public static boolean isRenderingHand() {
        return RENDERING_HAND;
    }

    public static boolean isRenderingGui() {
        return RENDERING_GUI;
    }

    public static void setGuiBatching() {
        GUI_BATCHING = true;
    }

    public static void resetGuiBatching() {
        GUI_BATCHING = false;
    }

    public static boolean isGuiBatching() {
        return GUI_BATCHING;
    }
}

