/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.AcceleratedRingBuffers;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.functions.ILayerFunction;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.ElementBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.StagingBufferPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.pools.meshes.MeshUploaderPool;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.buffers.environments.IBufferEnvironment;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleDynamicMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.SimpleMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.ITransformShaderProgramOverride;
import com.github.argon4w.acceleratedrendering.core.programs.overrides.IUploadingShaderProgramOverride;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.LongSupplier;
import lombok.Generated;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.system.MemoryUtil;

public class AcceleratedBufferBuilder
implements IAcceleratedVertexConsumer,
class_4588,
LongSupplier {
    public static final long SHARING_SIZE = 112L;
    public static final IMemoryInterface SHARING_TRANSFORM = new SimpleMemoryInterface(0L, 112L);
    public static final IMemoryInterface SHARING_NORMAL = new SimpleMemoryInterface(64L, 112L);
    public final IMemoryInterface varyingOffset;
    public final IMemoryInterface varyingSharing;
    public final IMemoryInterface varyingMesh;
    public final IMemoryInterface varyingShouldCull;
    private final Map<ServerMesh, MeshUploaderPool.MeshUploader> meshUploaders;
    private final StagingBufferPool.StagingBuffer vertexBuffer;
    private final StagingBufferPool.StagingBuffer varyingBuffer;
    private final ElementBufferPool.ElementSegment elementSegment;
    private final AcceleratedRingBuffers.Buffers buffer;
    private final ILayerFunction function;
    private final class_1921 renderType;
    private final IMemoryLayout<class_296> layout;
    private final ICullingProgramDispatcher cullingProgramDispatcher;
    private final ITransformShaderProgramOverride transformOverride;
    private final IUploadingShaderProgramOverride uploadingOverride;
    private final class_293.class_5596 mode;
    private final long vertexSize;
    private final int polygonSize;
    private final int polygonElementCount;
    private final IMemoryInterface posOffset;
    private final IMemoryInterface colorOffset;
    private final IMemoryInterface uv0Offset;
    private final IMemoryInterface uv1Offset;
    private final IMemoryInterface uv2Offset;
    private final IMemoryInterface normalOffset;
    private final Matrix4f cachedTransformValue;
    private final Matrix3f cachedNormalValue;
    private int elementCount;
    private int meshVertexCount;
    private int vertexCount;
    private long vertexAddress;
    private long sharingAddress;
    private int activeSharing;
    private int cachedSharing;
    private boolean outdated;
    private Matrix4f cachedTransform;
    private Matrix3f cachedNormal;

    public AcceleratedBufferBuilder(StagingBufferPool.StagingBuffer vertexBuffer, StagingBufferPool.StagingBuffer varyingBuffer, ElementBufferPool.ElementSegment elementSegment, AcceleratedRingBuffers.Buffers buffer, ILayerFunction layerFunction, class_1921 renderType) {
        IBufferEnvironment environment = buffer.getBufferEnvironment();
        this.varyingOffset = new SimpleDynamicMemoryInterface(0L, this);
        this.varyingSharing = new SimpleDynamicMemoryInterface(4L, this);
        this.varyingMesh = new SimpleDynamicMemoryInterface(8L, this);
        this.varyingShouldCull = new SimpleDynamicMemoryInterface(12L, this);
        this.meshUploaders = new Reference2ObjectLinkedOpenHashMap();
        this.vertexBuffer = vertexBuffer;
        this.varyingBuffer = varyingBuffer;
        this.elementSegment = elementSegment;
        this.buffer = buffer;
        this.function = layerFunction;
        this.renderType = renderType;
        this.layout = environment.getLayout();
        this.cullingProgramDispatcher = environment.selectCullingProgramDispatcher(this.renderType);
        this.transformOverride = environment.getTransformProgramOverride(this.renderType);
        this.uploadingOverride = environment.getUploadingProgramOverride(this.renderType);
        this.mode = this.renderType.field_20973;
        this.polygonSize = this.mode.field_27384;
        this.vertexSize = this.buffer.getVertexSize();
        this.polygonElementCount = this.mode.method_31973(this.polygonSize);
        this.posOffset = this.layout.getElement(class_296.field_52107);
        this.colorOffset = this.layout.getElement(class_296.field_52108);
        this.uv0Offset = this.layout.getElement(class_296.field_52109);
        this.uv1Offset = this.layout.getElement(class_296.field_52111);
        this.uv2Offset = this.layout.getElement(class_296.field_52112);
        this.normalOffset = this.layout.getElement(class_296.field_52113);
        this.cachedTransformValue = new Matrix4f();
        this.cachedNormalValue = new Matrix3f();
        this.elementCount = 0;
        this.meshVertexCount = 0;
        this.vertexCount = 0;
        this.vertexAddress = -1L;
        this.sharingAddress = -1L;
        this.activeSharing = -1;
        this.cachedSharing = -1;
        this.cachedTransform = null;
        this.cachedNormal = null;
    }

    public class_4588 method_56824(class_4587.class_4665 pPose, float pX, float pY, float pZ) {
        this.beginTransform(pPose.method_23761(), pPose.method_23762());
        return this.method_22912(pX, pY, pZ);
    }

    public class_4588 method_22912(float pX, float pY, float pZ) {
        long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize());
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize());
        this.vertexAddress = vertexAddress;
        this.posOffset.putFloat(vertexAddress + 0L, pX);
        this.posOffset.putFloat(vertexAddress + 4L, pY);
        this.posOffset.putFloat(vertexAddress + 8L, pZ);
        this.varyingOffset.putInt(varyingAddress, 0);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(vertexAddress, 0);
        ++this.vertexCount;
        ++this.elementCount;
        if (this.elementCount >= this.polygonSize) {
            this.elementSegment.countElements(this.polygonElementCount);
            this.elementCount = 0;
            this.activeSharing = -1;
        }
        return this;
    }

    public class_4588 method_1336(int pRed, int pGreen, int pBlue, int pAlpha) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.colorOffset.putByte(this.vertexAddress + 0L, (byte)pRed);
        this.colorOffset.putByte(this.vertexAddress + 1L, (byte)pGreen);
        this.colorOffset.putByte(this.vertexAddress + 2L, (byte)pBlue);
        this.colorOffset.putByte(this.vertexAddress + 3L, (byte)pAlpha);
        return this;
    }

    public class_4588 method_22913(float pU, float pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv0Offset.putFloat(this.vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(this.vertexAddress + 4L, pV);
        return this;
    }

    public class_4588 method_60796(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv1Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv1Offset.putShort(this.vertexAddress + 2L, (short)pV);
        return this;
    }

    public class_4588 method_22921(int pU, int pV) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.uv2Offset.putShort(this.vertexAddress + 0L, (short)pU);
        this.uv2Offset.putShort(this.vertexAddress + 2L, (short)pV);
        return this;
    }

    public class_4588 method_60831(class_4587.class_4665 pPose, float pNormalX, float pNormalY, float pNormalZ) {
        Matrix3f normal = pPose.method_23762();
        if (this.activeSharing == -1) {
            return super.method_60831(pPose, pNormalX, pNormalY, pNormalZ);
        }
        if (!normal.equals((Object)this.cachedNormal)) {
            SHARING_NORMAL.putMatrix3f(this.sharingAddress, normal);
        }
        return this.method_22914(pNormalX, pNormalY, pNormalZ);
    }

    public class_4588 method_22914(float pNormalX, float pNormalY, float pNormalZ) {
        if (this.vertexAddress == -1L) {
            throw new IllegalStateException("Vertex not building!");
        }
        this.normalOffset.putNormal(this.vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(this.vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(this.vertexAddress + 2L, pNormalZ);
        return this;
    }

    public void method_23919(float pX, float pY, float pZ, int pColor, float pU, float pV, int pPackedOverlay, int pPackedLight, float pNormalX, float pNormalY, float pNormalZ) {
        long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize());
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize());
        this.posOffset.putFloat(vertexAddress + 0L, pX);
        this.posOffset.putFloat(vertexAddress + 4L, pY);
        this.posOffset.putFloat(vertexAddress + 8L, pZ);
        this.colorOffset.putInt(vertexAddress, class_5253.class_8045.method_60675((int)pColor));
        this.uv0Offset.putFloat(vertexAddress + 0L, pU);
        this.uv0Offset.putFloat(vertexAddress + 4L, pV);
        this.uv1Offset.putInt(vertexAddress, pPackedOverlay);
        this.uv2Offset.putInt(vertexAddress, pPackedLight);
        this.normalOffset.putNormal(vertexAddress + 0L, pNormalX);
        this.normalOffset.putNormal(vertexAddress + 1L, pNormalY);
        this.normalOffset.putNormal(vertexAddress + 2L, pNormalZ);
        this.varyingOffset.putInt(varyingAddress, 0);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(varyingAddress, 0);
        ++this.vertexCount;
        ++this.elementCount;
        if (this.elementCount >= this.polygonSize) {
            this.elementSegment.countElements(this.polygonElementCount);
            this.elementCount = 0;
            this.activeSharing = -1;
        }
    }

    @Override
    public void beginTransform(Matrix4f transform, Matrix3f normal) {
        if (CoreFeature.shouldCacheIdenticalPose() && transform.equals((Object)this.cachedTransform) && normal.equals((Object)this.cachedNormal)) {
            this.activeSharing = this.cachedSharing;
            return;
        }
        this.cachedTransform = this.cachedTransformValue.set((Matrix4fc)transform);
        this.cachedNormal = this.cachedNormalValue.set((Matrix3fc)normal);
        this.sharingAddress = this.buffer.reserveSharing();
        this.activeSharing = this.cachedSharing = this.buffer.getSharing();
        SHARING_TRANSFORM.putMatrix4f(this.sharingAddress, transform);
        SHARING_NORMAL.putMatrix3f(this.sharingAddress, normal);
    }

    @Override
    public void endTransform() {
        this.cachedTransform = null;
        this.cachedNormal = null;
        this.activeSharing = -1;
        this.cachedSharing = -1;
    }

    @Override
    public void addClientMesh(ByteBuffer meshBuffer, int size, int color, int light, int overlay) {
        long bufferSize = this.vertexSize * (long)size;
        long vertexAddress = this.vertexBuffer.reserve(bufferSize);
        long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize() * (long)size);
        MemoryUtil.memCopy((long)MemoryUtil.memAddress0((Buffer)meshBuffer), (long)vertexAddress, (long)bufferSize);
        this.colorOffset.putInt(vertexAddress, class_5253.class_8045.method_60675((int)color));
        this.uv1Offset.putInt(vertexAddress, overlay);
        this.uv2Offset.putInt(vertexAddress, light);
        this.varyingSharing.putInt(varyingAddress, this.activeSharing);
        this.varyingMesh.putInt(varyingAddress, -1);
        this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
        this.transformOverride.uploadVarying(varyingAddress, 0);
        for (int i = 0; i < size; ++i) {
            this.varyingOffset.at(i).putInt(varyingAddress, i);
        }
        this.elementSegment.countElements(this.mode.method_31973(size));
        this.vertexCount += size;
    }

    @Override
    public void addServerMesh(ServerMesh serverMesh, int color, int light, int overlay) {
        if (CoreFeature.shouldUploadMeshImmediately()) {
            int meshSize = serverMesh.size();
            long vertexAddress = this.vertexBuffer.reserve(this.getVertexSize() * (long)meshSize);
            long varyingAddress = this.varyingBuffer.reserve(this.getVaryingSize() * (long)meshSize);
            this.colorOffset.putInt(vertexAddress, class_5253.class_8045.method_60675((int)color));
            this.uv1Offset.putInt(vertexAddress, overlay);
            this.uv2Offset.putInt(vertexAddress, light);
            this.varyingSharing.putInt(varyingAddress, this.activeSharing);
            this.varyingMesh.putInt(varyingAddress, serverMesh.offset());
            this.varyingShouldCull.putInt(varyingAddress, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
            this.transformOverride.uploadVarying(varyingAddress, 0);
            for (int i = 0; i < meshSize; ++i) {
                this.varyingOffset.at(i).putInt(varyingAddress, i);
            }
            this.elementSegment.countElements(this.mode.method_31973(meshSize));
            this.vertexCount += meshSize;
            return;
        }
        int meshSize = serverMesh.size();
        MeshUploaderPool.MeshUploader meshUploader = this.meshUploaders.get(serverMesh);
        if (meshUploader == null) {
            meshUploader = this.buffer.getMeshUploader();
            meshUploader.setServerMesh(serverMesh);
            meshUploader.setUploadingOverride(this.uploadingOverride);
            this.meshUploaders.put(serverMesh, meshUploader);
        }
        this.elementSegment.countElements(this.mode.method_31973(meshSize));
        this.meshVertexCount += meshSize;
        meshUploader.addUpload(color, light, overlay, this.activeSharing, this.cullingProgramDispatcher.shouldCull() ? 1 : 0);
    }

    @Override
    public <T> void doRender(IAcceleratedRenderer<T> renderer, T context, Matrix4f transform, Matrix3f normal, int light, int overlay, int color) {
        renderer.render(this, context, transform, normal, light, overlay, color);
    }

    @Override
    public class_4588 decorate(class_4588 buffer) {
        return buffer;
    }

    @Override
    public boolean isAccelerated() {
        return true;
    }

    @Override
    public class_1921 getRenderType() {
        return this.renderType;
    }

    @Override
    public long getAsLong() {
        return this.getVaryingSize();
    }

    public long getVaryingSize() {
        return this.transformOverride.getVaryingSize();
    }

    public int getTotalVertexCount() {
        return this.vertexCount + this.meshVertexCount;
    }

    public boolean isEmpty() {
        return this.getTotalVertexCount() == 0;
    }

    public void setOutdated() {
        this.outdated = true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcceleratedBufferBuilder)) {
            return false;
        }
        AcceleratedBufferBuilder other = (AcceleratedBufferBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        class_1921 this$renderType = this.getRenderType();
        class_1921 other$renderType = other.getRenderType();
        if (this$renderType == null ? other$renderType != null : !this$renderType.equals(other$renderType)) {
            return false;
        }
        IMemoryLayout<class_296> this$layout = this.getLayout();
        IMemoryLayout<class_296> other$layout = other.getLayout();
        return !(this$layout == null ? other$layout != null : !this$layout.equals(other$layout));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AcceleratedBufferBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        class_1921 $renderType = this.getRenderType();
        result = result * 59 + ($renderType == null ? 43 : $renderType.hashCode());
        IMemoryLayout<class_296> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : $layout.hashCode());
        return result;
    }

    @Generated
    public IMemoryInterface getVaryingOffset() {
        return this.varyingOffset;
    }

    @Generated
    public IMemoryInterface getVaryingSharing() {
        return this.varyingSharing;
    }

    @Generated
    public IMemoryInterface getVaryingMesh() {
        return this.varyingMesh;
    }

    @Generated
    public IMemoryInterface getVaryingShouldCull() {
        return this.varyingShouldCull;
    }

    @Generated
    public Map<ServerMesh, MeshUploaderPool.MeshUploader> getMeshUploaders() {
        return this.meshUploaders;
    }

    @Generated
    public StagingBufferPool.StagingBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    @Generated
    public StagingBufferPool.StagingBuffer getVaryingBuffer() {
        return this.varyingBuffer;
    }

    @Generated
    public ElementBufferPool.ElementSegment getElementSegment() {
        return this.elementSegment;
    }

    @Generated
    public AcceleratedRingBuffers.Buffers getBuffer() {
        return this.buffer;
    }

    @Generated
    public ILayerFunction getFunction() {
        return this.function;
    }

    @Override
    @Generated
    public IMemoryLayout<class_296> getLayout() {
        return this.layout;
    }

    @Generated
    public ICullingProgramDispatcher getCullingProgramDispatcher() {
        return this.cullingProgramDispatcher;
    }

    @Generated
    public ITransformShaderProgramOverride getTransformOverride() {
        return this.transformOverride;
    }

    @Generated
    public IUploadingShaderProgramOverride getUploadingOverride() {
        return this.uploadingOverride;
    }

    @Generated
    public class_293.class_5596 getMode() {
        return this.mode;
    }

    @Generated
    public long getVertexSize() {
        return this.vertexSize;
    }

    @Override
    @Generated
    public int getPolygonSize() {
        return this.polygonSize;
    }

    @Generated
    public IMemoryInterface getColorOffset() {
        return this.colorOffset;
    }

    @Generated
    public IMemoryInterface getUv1Offset() {
        return this.uv1Offset;
    }

    @Generated
    public IMemoryInterface getUv2Offset() {
        return this.uv2Offset;
    }

    @Generated
    public int getMeshVertexCount() {
        return this.meshVertexCount;
    }

    @Generated
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }
}

