/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.core.meshes;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.meshes.EmptyMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.IMeshCollector;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.nio.ByteBuffer;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_9799;

public class ClientMesh
implements IMesh {
    private final int size;
    private final ByteBuffer vertexBuffer;

    @Override
    public void write(IAcceleratedVertexConsumer extension, int color, int light, int overlay) {
        extension.addClientMesh(this.vertexBuffer, this.size, color, light, overlay);
    }

    @Generated
    public ClientMesh(int size, ByteBuffer vertexBuffer) {
        this.size = size;
        this.vertexBuffer = vertexBuffer;
    }

    public static class Builder
    implements IMesh.Builder {
        public static final Builder INSTANCE = new Builder();
        private final Set<class_9799> builders = new ReferenceLinkedOpenHashSet();

        private Builder() {
        }

        @Override
        public IMesh build(IMeshCollector collector) {
            int vertexCount = collector.getVertexCount();
            if (vertexCount == 0) {
                return EmptyMesh.INSTANCE;
            }
            class_9799 builder = collector.getBuffer();
            class_9799.class_9800 result = builder.method_60807();
            if (result == null) {
                builder.close();
                return EmptyMesh.INSTANCE;
            }
            this.builders.add(builder);
            return new ClientMesh(vertexCount, result.method_60817());
        }

        @Override
        public IMesh build(IMeshCollector collector, boolean forceDense) {
            return this.build(collector);
        }

        @Override
        public void delete() {
            for (class_9799 builder : this.builders) {
                builder.method_60811();
                builder.close();
            }
        }
    }
}

