/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.filter;

import com.github.argon4w.acceleratedrendering.configs.FeatureConfig;
import com.github.argon4w.acceleratedrendering.configs.FeatureStatus;
import com.github.argon4w.acceleratedrendering.core.utils.RegistryFilter;
import com.github.argon4w.acceleratedrendering.features.filter.FilterType;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_7923;

public class FilterFeature {
    private static final Deque<FeatureStatus> ENTITIES_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Deque<FeatureStatus> BLOCK_ENTITIES_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Deque<FeatureStatus> ITEM_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Deque<FeatureStatus> STAGE_FILTER_CONTROLLER_STACK = new ArrayDeque<FeatureStatus>();
    private static final Set<class_1299<?>> ENTITY_FILTER_VALUES = RegistryFilter.filterValues(class_7923.field_41177, (List)FeatureConfig.CONFIG.filterEntityFilterValues.get());
    private static final Set<class_2591<?>> BLOCK_ENTITY_FILTER_VALUES = RegistryFilter.filterValues(class_7923.field_41181, (List)FeatureConfig.CONFIG.filterBlockEntityFilterValues.get());
    private static final Set<class_1792> ITEM_FILTER_VALUES = RegistryFilter.filterValues(class_7923.field_41178, (List)FeatureConfig.CONFIG.filterItemFilterValues.get());
    private static final Set<String> STAGE_FILTER_VALUES = new ReferenceOpenHashSet((Collection)FeatureConfig.CONFIG.filterStageFilterValues.get());

    public static boolean isEnabled() {
        return FeatureConfig.CONFIG.filterFeatureStatus.get() == FeatureStatus.ENABLED;
    }

    public static boolean testEntity(class_1297 entity) {
        return FilterFeature.getEntityFilterType().test(ENTITY_FILTER_VALUES, entity.method_5864());
    }

    public static boolean testBlockEntity(class_2586 entity) {
        return FilterFeature.getBlockEntityFilterType().test(BLOCK_ENTITY_FILTER_VALUES, entity.method_11017());
    }

    public static boolean testItem(class_1799 itemStack) {
        return FilterFeature.getItemFilterType().test(ITEM_FILTER_VALUES, itemStack.method_7909());
    }

    public static boolean shouldFilterEntities() {
        return FilterFeature.getEntityFilterSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldFilterBlockEntities() {
        return FilterFeature.getBlockEntityFilterSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldFilterItems() {
        return FilterFeature.getItemFilterSetting() == FeatureStatus.ENABLED;
    }

    public static boolean shouldFilterStage() {
        return FilterFeature.getStageFilterSetting() == FeatureStatus.ENABLED;
    }

    public static FilterType getEntityFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.filterEntityFilterType.get());
    }

    public static FilterType getBlockEntityFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.filterBlockEntityFilterType.get());
    }

    public static FilterType getItemFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.filterItemFilterType.get());
    }

    public static FilterType getStageFilterType() {
        return (FilterType)((Object)FeatureConfig.CONFIG.filterStageFilterType.get());
    }

    public static void disableEntityFilter() {
        ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableBlockEntityFilter() {
        BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableItemFilter() {
        ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void disableStageFilter() {
        STAGE_FILTER_CONTROLLER_STACK.push(FeatureStatus.DISABLED);
    }

    public static void forceEnableEntityFilter() {
        ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableBlockEntityFilter() {
        BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableItemFilter() {
        ITEM_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceEnableStageFilter() {
        STAGE_FILTER_CONTROLLER_STACK.push(FeatureStatus.ENABLED);
    }

    public static void forceSetEntityFilter(FeatureStatus status) {
        ENTITIES_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void forceSetBlockEntityFilter(FeatureStatus status) {
        BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void forceSetItemFilter(FeatureStatus status) {
        ITEM_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void forceSetStageFilter(FeatureStatus status) {
        STAGE_FILTER_CONTROLLER_STACK.push(status);
    }

    public static void resetEntityFilter() {
        ENTITIES_FILTER_CONTROLLER_STACK.pop();
    }

    public static void resetBlockEntityFilter() {
        BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.pop();
    }

    public static void resetItemFilter() {
        ITEM_FILTER_CONTROLLER_STACK.pop();
    }

    public static void resetStageFilter() {
        STAGE_FILTER_CONTROLLER_STACK.pop();
    }

    public static FeatureStatus getEntityFilterSetting() {
        return ENTITIES_FILTER_CONTROLLER_STACK.isEmpty() ? FilterFeature.getDefaultEntityFilterSetting() : ENTITIES_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getBlockEntityFilterSetting() {
        return BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.isEmpty() ? FilterFeature.getDefaultBlockEntityFilterSetting() : BLOCK_ENTITIES_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getItemFilterSetting() {
        return ITEM_FILTER_CONTROLLER_STACK.isEmpty() ? FilterFeature.getDefaultItemFilterSetting() : ITEM_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getStageFilterSetting() {
        return STAGE_FILTER_CONTROLLER_STACK.isEmpty() ? FilterFeature.getDefaultStageFilterSetting() : STAGE_FILTER_CONTROLLER_STACK.peek();
    }

    public static FeatureStatus getDefaultEntityFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.filterEntityFilter.get());
    }

    public static FeatureStatus getDefaultBlockEntityFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.filterBlockEntityFilter.get());
    }

    public static FeatureStatus getDefaultItemFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.filterItemFilter.get());
    }

    public static FeatureStatus getDefaultStageFilterSetting() {
        return (FeatureStatus)((Object)FeatureConfig.CONFIG.filterStageFilter.get());
    }
}

