/*
 * Decompiled with CFR 0.152.
 */
package com.github.argon4w.acceleratedrendering.features.items.mixins.gui;

import com.github.argon4w.acceleratedrendering.core.CoreBuffers;
import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.CoreStates;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerDrawType;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedGuiGraphics;
import com.github.argon4w.acceleratedrendering.features.items.gui.GuiBatchingController;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_308;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_332.class})
public class GuiGraphicsMixin
implements IAcceleratedGuiGraphics {
    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;getModel(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)Lnet/minecraft/client/resources/model/BakedModel;")})
    public void startRenderingGui(class_1309 entity, class_1937 level, class_1799 stack, int x, int y, int seed, int guiOffset, CallbackInfo ci) {
        if (CoreFeature.isLoaded()) {
            CoreFeature.setRenderingGui();
        }
    }

    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V", shift=At.Shift.AFTER)})
    public void stopRenderingGui(class_1309 entity, class_1937 level, class_1799 stack, int x, int y, int seed, int guiOffset, CallbackInfo ci) {
        CoreFeature.resetRenderingGui();
        if (!CoreFeature.isGuiBatching() && CoreFeature.isLoaded()) {
            this.flushItemBatching();
        }
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", shift=At.Shift.BEFORE), @At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V", shift=At.Shift.BEFORE, ordinal=0), @At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V", shift=At.Shift.BEFORE, ordinal=2)})
    public void startRenderDecorationPart(class_327 font, class_1799 stack, int x, int y, String text, CallbackInfo ci) {
        GuiBatchingController.INSTANCE.useOverlayTarget();
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V", shift=At.Shift.AFTER, ordinal=1), @At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(Lnet/minecraft/client/renderer/RenderType;IIIII)V", shift=At.Shift.AFTER, ordinal=2)})
    public void stopRenderDecorationPart(class_327 font, class_1799 stack, int x, int y, String text, CallbackInfo ci) {
        GuiBatchingController.INSTANCE.resetOverlayTarget();
    }

    @WrapOperation(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V")})
    public void setupBatchingLayers(class_918 instance, class_1799 itemStack, class_811 displayContext, boolean leftHand, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay, class_1087 bakedModel, Operation<Void> original) {
        boolean useFlatLight;
        boolean bl = useFlatLight = CoreFeature.isGuiBatching() && !bakedModel.method_24304();
        if (useFlatLight) {
            CoreFeature.forceSetDefaultLayer(1);
            CoreFeature.forceSetDefaultLayerBeforeFunction(class_308::method_24210);
            CoreFeature.forceSetDefaultLayerAfterFunction(class_308::method_24211);
        }
        original.call(new Object[]{instance, itemStack, displayContext, leftHand, poseStack, bufferSource, combinedLight, combinedOverlay, bakedModel});
        if (useFlatLight) {
            CoreFeature.resetDefaultLayer();
            CoreFeature.resetDefaultLayerBeforeFunction();
            CoreFeature.resetDefaultLayerAfterFunction();
        }
    }

    @Override
    @Unique
    public void flushItemBatching() {
        CoreStates.recordBuffers();
        CoreBuffers.ENTITY.prepareBuffers();
        CoreBuffers.BLOCK.prepareBuffers();
        CoreBuffers.POS.prepareBuffers();
        CoreBuffers.POS_TEX.prepareBuffers();
        CoreBuffers.POS_TEX_COLOR.prepareBuffers();
        CoreBuffers.POS_COLOR_TEX_LIGHT.prepareBuffers();
        CoreStates.restoreBuffers();
        CoreBuffers.ENTITY.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.BLOCK.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.POS.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.POS_TEX.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.POS_TEX_COLOR.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.POS_COLOR_TEX_LIGHT.drawBuffers(LayerDrawType.ALL);
        CoreBuffers.ENTITY.clearBuffers();
        CoreBuffers.BLOCK.clearBuffers();
        CoreBuffers.POS.clearBuffers();
        CoreBuffers.POS_TEX.clearBuffers();
        CoreBuffers.POS_TEX_COLOR.clearBuffers();
        CoreBuffers.POS_COLOR_TEX_LIGHT.clearBuffers();
    }
}

