package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import lombok.EqualsAndHashCode;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_2350;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.nio.ByteBuffer;

@ExtensionMethod	(VertexConsumerExtension.class)
@EqualsAndHashCode	(
		onlyExplicitlyIncluded	= true,
		callSuper				= false
)
public class AcceleratedSheetedDecalTextureGenerator extends AcceleratedVertexConsumerWrapper {

	@EqualsAndHashCode.Include private	final	class_4588	delegate;
	@EqualsAndHashCode.Include private	final	Matrix4f		cameraInverse;
	private                             final	Matrix3f		normalInverse;
	private								final	float			textureScale;

	private								final	Vector3f		cachedCamera;
	private								final	Vector3f		cachedNormal;

	private										float			vertexX;
	private										float			vertexY;
	private										float			vertexZ;

	public AcceleratedSheetedDecalTextureGenerator(
			class_4588	delegate,
			Matrix4f		cameraInverse,
			Matrix3f		normalInverse,
			float			textureScale
	) {
		this.delegate		= delegate;
		this.cameraInverse	= cameraInverse;
		this.normalInverse	= normalInverse;
		this.textureScale	= textureScale;

		this.cachedCamera	= new Vector3f();
		this.cachedNormal	= new Vector3f();

		this.vertexX		= 0;
		this.vertexY		= 0;
		this.vertexZ		= 0;
	}

	@Override
	protected class_4588 getDelegate() {
		return delegate;
	}

	@Override
	public class_4588 decorate(class_4588 buffer) {
		return new AcceleratedSheetedDecalTextureGenerator(
				getDelegate				()
						.getAccelerated	()
						.decorate		(buffer),
				cameraInverse,
				normalInverse,
				textureScale
		);
	}

	@Override
	public void addClientMesh(
			ByteBuffer	meshBuffer,
			int			size,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addClientMesh	(
						meshBuffer,
						size,
						-1,
						light,
						overlay
				);
	}

	@Override
	public void addServerMesh(
			ServerMesh	serverMesh,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addServerMesh	(
						serverMesh,
						-1,
						light,
						overlay
				);
	}

	@Override
	public class_4588 method_22912(
			float pX,
			float pY,
			float pZ
	) {
		vertexX = pX;
		vertexY = pY;
		vertexZ = pZ;

		delegate.method_22912(
				pX,
				pY,
				pZ
		);
		return this;
	}

	@Override
	public class_4588 method_22913(float pU, float pV) {
		return this;
	}

	@Override
	public class_4588 method_1336(
			int pRed,
			int pGreen,
			int pBlue,
			int pAlpha
	) {
		delegate.method_39415(-1);
		return this;
	}

	@Override
	public class_4588 method_22914(
			float pNormalX,
			float pNormalY,
			float pNormalZ
	) {
		delegate.method_22914(
				pNormalX,
				pNormalY,
				pNormalZ
		);

		var normal		= normalInverse.transform(
				pNormalX,
				pNormalY,
				pNormalZ,
				cachedNormal
		);

		var camera		= cameraInverse.transformPosition(
				vertexX,
				vertexY,
				vertexZ,
				cachedCamera
		);

		var direction	= class_2350.method_10147(
				normal.x(),
				normal.y(),
				normal.z()
		);

		camera	.rotateY((float) 	Math.PI);
		camera	.rotateX((float) (-	Math.PI / 2));
		camera	.rotate	(direction.method_23224());

		delegate.method_22913	(-camera.x() * textureScale, -camera.y() * textureScale);
		return this;
	}

	@Override
	public void method_23919(
			float	x,
			float	y,
			float	z,
			int		color,
			float	u,
			float	v,
			int		packedOverlay,
			int		packedLight,
			float	normalX,
			float	normalY,
			float	normalZ
	) {
		this
				.method_22912	(x,			y,			z)
				.method_39415	(color)
				.method_22913		(u,			v)
				.method_22922	(packedOverlay)
				.method_60803	(packedLight)
				.method_22914	(normalX,	normalY,	normalZ);
	}
}
