package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1058;
import net.minecraft.class_4588;

@AllArgsConstructor
@EqualsAndHashCode	(callSuper = false)
@ExtensionMethod	(VertexConsumerExtension.class)
public class AcceleratedSpriteCoordinateExpander extends AcceleratedVertexConsumerWrapper {

	private final class_4588		delegate;
	private final class_1058	sprite;

	@Override
	public class_4588 getDelegate() {
		return delegate;
	}

	@Override
	public class_4588 decorate(class_4588 buffer) {
		return new AcceleratedSpriteCoordinateExpander(
				getDelegate				()
						.getAccelerated	()
						.decorate		(buffer),
				sprite
		);
	}

	@Override
	public class_4588 method_22913(float pU, float pV) {
		delegate.method_22913(
				sprite.method_4580(pU),
				sprite.method_4570(pV)
		);
		return this;
	}

	@Override
	public void method_23919(
			float	pX,
			float	pY,
			float	pZ,
			int		pColor,
			float	pU,
			float	pV,
			int		pPackedOverlay,
			int		pPackedLight,
			float	pNormalX,
			float	pNormalY,
			float	pNormalZ
	) {
		delegate.method_23919(
				pX,
				pY,
				pZ,
				pColor,
				sprite.method_4580(pU),
				sprite.method_4570(pV),
				pPackedOverlay,
				pPackedLight,
				pNormalX,
				pNormalY,
				pNormalZ
		);
	}
}
