package com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.ServerMesh;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1921;
import net.minecraft.class_296;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.nio.ByteBuffer;

@ExtensionMethod(VertexConsumerExtension.class)
public abstract class AcceleratedVertexConsumerWrapper implements IAcceleratedVertexConsumer, class_4588 {

	@Override
	public		abstract class_4588 decorate	(class_4588 buffer);
	protected	abstract class_4588 getDelegate	();

	@Override
	public void beginTransform(Matrix4f transform, Matrix3f normal) {
		getDelegate				()
				.getAccelerated	()
				.beginTransform	(transform, normal);
	}

	@Override
	public void endTransform() {
		getDelegate()
				.getAccelerated	()
				.endTransform	();
	}

	@Override
	public boolean isAccelerated() {
		return getDelegate		()
				.getAccelerated	()
				.isAccelerated	();
	}

	@Override
	public class_1921 getRenderType() {
		return getDelegate		()
				.getAccelerated	()
				.getRenderType	();
	}

	@Override
	public IMemoryLayout<class_296> getLayout() {
		return getDelegate		()
				.getAccelerated	()
				.getLayout		();
	}

	@Override
	public int getPolygonSize() {
		return getDelegate		()
				.getAccelerated	()
				.getPolygonSize	();
	}

	@Override
	public void addClientMesh(
			ByteBuffer meshBuffer,
			int			size,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addClientMesh	(
						meshBuffer,
						size,
						color,
						light,
						overlay
				);
	}

	@Override
	public void addServerMesh(
			ServerMesh	serverMesh,
			int			color,
			int			light,
			int			overlay
	) {
		getDelegate				()
				.getAccelerated	()
				.addServerMesh	(
						serverMesh,
						color,
						light,
						overlay
				);
	}

	@Override
	public <T> void doRender(
			IAcceleratedRenderer<T> renderer,
			T						context,
			Matrix4f				transform,
			Matrix3f				normal,
			int						light,
			int						overlay,
			int						color
	) {
		renderer.render(
				this,
				context,
				transform,
				normal,
				light,
				overlay,
				color
		);
	}

	@Override
	public class_4588 method_22912(
			float x,
			float y,
			float z
	) {
		getDelegate().method_22912(
				x,
				y,
				z
		);
		return this;
	}

	@Override
	public class_4588 method_56824(
			class_4587.class_4665	pose,
			float			x,
			float			y,
			float			z
	) {
		getDelegate().method_56824(
				pose,
				x,
				y,
				z
		);
		return this;
	}

	@Override
	public class_4588 method_1336(
			int red,
			int green,
			int blue,
			int alpha
	) {
		getDelegate().method_1336(
				red,
				green,
				blue,
				alpha
		);
		return this;
	}

	@Override
	public class_4588 method_22913(float u, float v) {
		getDelegate().method_22913(u, v);
		return this;
	}

	@Override
	public class_4588 method_60796(int u, int v) {
		getDelegate().method_60796(u, v);
		return this;
	}

	@Override
	public class_4588 method_22921(int u, int v) {
		getDelegate().method_22921(u, v);
		return this;
	}

	@Override
	public class_4588 method_22914(
			float normalX,
			float normalY,
			float normalZ
	) {
		getDelegate().method_22914(
				normalX,
				normalY,
				normalZ
		);
		return this;
	}

	@Override
	public class_4588 method_60831(
			class_4587.class_4665	pose,
			float			normalX,
			float			normalY,
			float			normalZ
	) {
		getDelegate().method_60831(
				pose,
				normalX,
				normalY,
				normalZ
		);
		return this;
	}

	@Override
	public void method_23919(
			float	x,
			float	y,
			float	z,
			int		color,
			float	u,
			float	v,
			int		packedOverlay,
			int		packedLight,
			float	normalX,
			float	normalY,
			float	normalZ
	) {
		getDelegate().method_23919(
				x,
				y,
				z,
				color,
				u,
				v,
				packedOverlay,
				packedLight,
				normalX,
				normalY,
				normalZ
		);
	}
}
