package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.CullerUtils;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import net.minecraft.class_1011;
import net.minecraft.class_296;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_9799;

public class CulledMeshCollector implements class_4588, IMeshCollector {

	private final	int									polygonSize;
	private final	class_1011							texture;
	private	final	IMemoryLayout<class_296>	layout;
	private final	SimpleMeshCollector					meshCollector;
	private final	Vertex[]							polygon;

	private			int									vertexIndex;

	public CulledMeshCollector(IAcceleratedVertexConsumer vertexConsumer) {
		this.polygonSize	= vertexConsumer	.getPolygonSize	();
		this.texture		= vertexConsumer	.downloadTexture();
		this.layout			= vertexConsumer	.getLayout		();
		this.meshCollector	= new SimpleMeshCollector			(this.layout);
		this.polygon		= new Vertex						[this.polygonSize];

		this.vertexIndex	= -1;
	}

	@Override
	public void flush() {
		if (vertexIndex >= polygonSize - 1) {
			vertexIndex = -1;

			if (!CullerUtils.shouldCull(polygon, texture)) {
				for (var vertex : polygon) {
					var vertexPosition	= vertex.getPosition();
					var vertexUV		= vertex.getUv		();
					var vertexNormal	= vertex.getNormal	();

					meshCollector.method_23919(
							vertexPosition	.x,
							vertexPosition	.y,
							vertexPosition	.z,
							vertex			.getPackedColor(),
							vertexUV		.x,
							vertexUV		.y,
							class_4608	.field_21444,
							vertex			.getPackedLight(),
							vertexNormal	.x,
							vertexNormal	.y,
							vertexNormal	.z
					);
				}
			}
		}
	}

	@Override
	public class_4588 method_22912(
			float pX,
			float pY,
			float pZ
	) {
		flush();
		polygon[++ vertexIndex]					= new Vertex();
		polygon[vertexIndex].getPosition().x	= pX;
		polygon[vertexIndex].getPosition().y	= pY;
		polygon[vertexIndex].getPosition().z	= pZ;

		return this;
	}

	@Override
	public class_4588 method_1336(
			int pRed,
			int pGreen,
			int pBlue,
			int pAlpha
	) {
		if (vertexIndex < 0) {
			throw new IllegalStateException("Vertex not building!");
		}

		polygon[vertexIndex].getColor().x = pRed;
		polygon[vertexIndex].getColor().y = pGreen;
		polygon[vertexIndex].getColor().z = pBlue;
		polygon[vertexIndex].getColor().w = pAlpha;

		return this;
	}

	@Override
	public class_4588 method_22913(float pU, float pV) {
		if (vertexIndex < 0) {
			throw new IllegalStateException("Vertex not building!");
		}

		polygon[vertexIndex].getUv().x = pU;
		polygon[vertexIndex].getUv().y = pV;

		return this;
	}

	@Override
	public class_4588 method_60796(int pU, int pV) {
		return this;
	}

	@Override
	public class_4588 method_22921(int pU, int pV) {
		if (vertexIndex < 0) {
			throw new IllegalStateException("Vertex not building!");
		}

		polygon[vertexIndex].getLight().x = pU;
		polygon[vertexIndex].getLight().y = pV;

		return this;
	}

	@Override
	public class_4588 method_22914(
			float pNormalX,
			float pNormalY,
			float pNormalZ
	) {
		if (vertexIndex < 0) {
			throw new IllegalStateException("Vertex not building!");
		}

		polygon[vertexIndex].getNormal().x = pNormalX;
		polygon[vertexIndex].getNormal().y = pNormalY;
		polygon[vertexIndex].getNormal().z = pNormalZ;
		return this;
	}

	@Override
	public IMeshData getData() {
		return meshCollector.getData();
	}

	@Override
	public class_9799 getBuffer() {
		return meshCollector.getBuffer();
	}

	@Override
	public IMemoryLayout<class_296> getLayout() {
		return meshCollector.getLayout();
	}

	@Override
	public int getVertexCount() {
		return meshCollector.getVertexCount();
	}
}
