package com.github.argon4w.acceleratedrendering.core.meshes.collectors;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryInterface;
import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import com.github.argon4w.acceleratedrendering.core.meshes.data.IMeshData;
import com.github.argon4w.acceleratedrendering.core.utils.PackedVector2i;
import com.github.argon4w.acceleratedrendering.core.utils.Vertex;
import lombok.Getter;
import net.minecraft.class_296;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_9799;

public class SimpleMeshCollector implements class_4588, IMeshCollector {

	@Getter private	final	IMemoryLayout<class_296>	layout;
	@Getter private	final	class_9799					buffer;
	@Getter private final	Vertex								vertex;
	@Getter private	final	IMeshData							data;

	private			final	long								vertexSize;
	private			final	IMemoryInterface					posOffset;
	private			final	IMemoryInterface					colorOffset;
	private			final	IMemoryInterface					uv0Offset;
	private			final	IMemoryInterface					uv2Offset;
	private			final	IMemoryInterface					normalOffset;

	@Getter private			long								vertexAddress;
	@Getter private			int									vertexCount;

	public SimpleMeshCollector(IMemoryLayout<class_296> layout) {
		this.layout			= layout;
		this.buffer			= new class_9799			(1024);
		this.vertex			= new Vertex					();
		this.data			= CoreFeature	.createMeshData	(layout);

		this.vertexSize		= this.layout	.getSize		();
		this.posOffset		= this.layout	.getElement		(class_296.field_52107);
		this.colorOffset	= this.layout	.getElement		(class_296.field_52108);
		this.uv0Offset		= this.layout	.getElement		(class_296.field_52110);
		this.uv2Offset		= this.layout	.getElement		(class_296.field_52112);
		this.normalOffset	= this.layout	.getElement		(class_296.field_52113);

		this.vertexAddress	= -1L;
		this.vertexCount	= 0;
	}

	@Override
	public void flush() {
		data.addVertex(vertex);
	}

	@Override
	public class_4588 method_22912(
			float pX,
			float pY,
			float pZ
	) {
		if (vertexCount != 0) {
			data.addVertex(vertex);
		}

		vertexCount ++;
		vertexAddress = buffer.method_60808((int) vertexSize);

		posOffset.putFloat(vertexAddress + 0L, pX);
		posOffset.putFloat(vertexAddress + 4L, pY);
		posOffset.putFloat(vertexAddress + 8L, pZ);

		var vertexPosition	= vertex.getPosition();

		vertexPosition.x	= pX;
		vertexPosition.y	= pY;
		vertexPosition.z	= pZ;

		return this;
	}

	@Override
	public class_4588 method_1336(
			int pRed,
			int pGreen,
			int pBlue,
			int pAlpha
	) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		colorOffset.putByte(vertexAddress + 0L, (byte) pRed);
		colorOffset.putByte(vertexAddress + 1L, (byte) pGreen);
		colorOffset.putByte(vertexAddress + 2L, (byte) pBlue);
		colorOffset.putByte(vertexAddress + 3L, (byte) pAlpha);

		var vertexColor	= vertex.getColor();

		vertexColor.x	= pRed;
		vertexColor.y	= pGreen;
		vertexColor.z	= pBlue;
		vertexColor.w	= pAlpha;

		return this;
	}

	@Override
	public class_4588 method_22913(float pU, float pV) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		uv0Offset.putFloat(vertexAddress + 0L, pU);
		uv0Offset.putFloat(vertexAddress + 4L, pV);

		var vertexUv	= vertex.getUv();

		vertexUv.x		= pU;
		vertexUv.y		= pV;

		return this;
	}

	@Override
	public class_4588 method_60796(int pU, int pV) {
		return this;
	}

	@Override
	public class_4588 method_22921(int pU, int pV) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		uv2Offset.putShort(vertexAddress + 0L, (short) pU);
		uv2Offset.putShort(vertexAddress + 2L, (short) pV);

		var vertexLight	= vertex.getLight();

		vertexLight.x	= pU;
		vertexLight.y	= pV;

		return this;
	}

	@Override
	public class_4588 method_22914(
			float pNormalX,
			float pNormalY,
			float pNormalZ
	) {
		if (vertexAddress == -1) {
			throw new IllegalStateException("Vertex not building!");
		}

		normalOffset.putNormal(vertexAddress + 0L, pNormalX);
		normalOffset.putNormal(vertexAddress + 1L, pNormalY);
		normalOffset.putNormal(vertexAddress + 2L, pNormalZ);

		var vertexNormal	= vertex.getNormal();

		vertexNormal.x		= pNormalX;
		vertexNormal.y		= pNormalY;
		vertexNormal.z		= pNormalZ;

		return this;
	}

	@Override
	public void method_23919(
			float	pX,
			float	pY,
			float	pZ,
			int		pColor,
			float	pU,
			float	pV,
			int		pPackedOverlay,
			int		pPackedLight,
			float	pNormalX,
			float	pNormalY,
			float	pNormalZ
	) {
		vertexCount++;
		vertexAddress = buffer.method_60808((int) vertexSize);

		posOffset	.putFloat	(vertexAddress + 0L,	pX);
		posOffset	.putFloat	(vertexAddress + 4L,	pY);
		posOffset	.putFloat	(vertexAddress + 8L,	pZ);
		colorOffset	.putInt		(vertexAddress,			class_5253.class_8045.method_60675(pColor));
		uv0Offset	.putFloat	(vertexAddress + 0L,	pU);
		uv0Offset	.putFloat	(vertexAddress + 4L,	pV);
		uv2Offset	.putInt		(vertexAddress,			pPackedLight);
		normalOffset.putNormal	(vertexAddress + 0L,	pNormalX);
		normalOffset.putNormal	(vertexAddress + 1L,	pNormalY);
		normalOffset.putNormal	(vertexAddress + 2L,	pNormalZ);

		data.addVertex(
				pX,
				pY,
				pZ,
				pU,
				pV,
				class_5253.class_5254.method_27765	(pColor),
				class_5253.class_5254.method_27766	(pColor),
				class_5253.class_5254.method_27767	(pColor),
				class_5253.class_5254.method_27762	(pColor),
				PackedVector2i	.unpackU(pPackedLight),
				PackedVector2i	.unpackV(pPackedLight),
				pNormalX,
				pNormalY,
				pNormalZ
		);
	}
}
