package com.github.argon4w.acceleratedrendering.core.meshes.data;

import com.github.argon4w.acceleratedrendering.core.buffers.memory.IMemoryLayout;
import net.minecraft.class_296;

public enum MeshMergeType {

	IGNORED,
	MERGED;

	public IMeshData create(IMemoryLayout<class_296> layout) {
		return create(this, layout);
	}

	public static IMeshData create(MeshMergeType type, IMemoryLayout<class_296> layout) {
		return switch (type) {
			case IGNORED	-> new ReferenceMeshData();
			case MERGED		-> new SimpleMeshData	(layout);
		};
	}
}
