package com.github.argon4w.acceleratedrendering.core.programs.overrides;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;

public class LoadShaderProgramOverridesEvent extends Event implements IModBusEvent {

	private final class_293															vertexFormat;
	private final Object2ObjectOpenHashMap<class_1921, ITransformShaderProgramOverride> transformOverrides;
	private final Object2ObjectOpenHashMap<class_1921, IUploadingShaderProgramOverride>	uploadingOverrides;

	public LoadShaderProgramOverridesEvent(class_293 vertexFormat) {
		this.vertexFormat		= vertexFormat;
		this.transformOverrides	= new Object2ObjectOpenHashMap<>();
		this.uploadingOverrides	= new Object2ObjectOpenHashMap<>();
	}

	public void loadFor(
			class_293			vertexFormat,
			class_1921				renderType,
			IShaderProgramOverride	override
	) {
		if (this.vertexFormat == vertexFormat) {
			switch (override) {
				case ITransformShaderProgramOverride transform	-> transformOverrides.put					(renderType, transform);
				case IUploadingShaderProgramOverride uploading	-> uploadingOverrides.put					(renderType, uploading);
				default											-> throw new UnsupportedOperationException	("Unsupported override type: " + override.getClass().getSimpleName());
			}
		}
	}

	public IShaderProgramOverrides getOverrides(ITransformShaderProgramOverride defaultTransformOverride, IUploadingShaderProgramOverride defaultUploadingOverride) {
		return new ProgramOverrides(
				transformOverrides,
				uploadingOverrides,
				defaultTransformOverride,
				defaultUploadingOverride
		);
	}

	@Getter
	public static class ProgramOverrides implements IShaderProgramOverrides {

		private final Object2ObjectOpenHashMap<class_1921, ITransformShaderProgramOverride> transformOverrides;
		private final Object2ObjectOpenHashMap<class_1921, IUploadingShaderProgramOverride>	uploadingOverrides;

		public ProgramOverrides(
				Object2ObjectOpenHashMap<class_1921, ITransformShaderProgramOverride>	transformOverrides,
				Object2ObjectOpenHashMap<class_1921, IUploadingShaderProgramOverride>	uploadingOverrides,
				ITransformShaderProgramOverride											defaultTransformOverride,
				IUploadingShaderProgramOverride											defaultUploadingOverride
		) {
			this.transformOverrides = transformOverrides;
			this.uploadingOverrides = uploadingOverrides;

			this.transformOverrides.defaultReturnValue(defaultTransformOverride);
			this.uploadingOverrides.defaultReturnValue(defaultUploadingOverride);
		}
	}
}
