package com.github.argon4w.acceleratedrendering.core.utils;

import net.minecraft.class_1011;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import org.joml.Vector3f;

public class CullerUtils {

	public static boolean shouldCull(Vertex[] vertices, class_1011 texture) {
		if (texture == null) {
			return false;
		}

		if (vertices.length == 4) {
			var vertex0 = new Vector3f(vertices[0].getPosition());
			var vector1 = new Vector3f(vertices[1].getPosition()).sub(vertex0);
			var vector2 = new Vector3f(vertices[2].getPosition()).sub(vertex0);
			var vector3 = new Vector3f(vertices[3].getPosition()).sub(vertex0);

			var length1 = vector1.cross(vector2).length();
			var length2 = vector1.cross(vector3).length();

			if (length1 == 0 && length2 == 0) {
				return true;
			}
		}

		var minU = 1.0f;
		var minV = 1.0f;
		var maxU = 0.0f;
		var maxV = 0.0f;

		for (var vertex : vertices) {
			var uv	= vertex.getUv();
			var u	= uv	.x;
			var v	= uv	.y;

			minU = Math.min(minU, u);
			minV = Math.min(minV, v);
			maxU = Math.max(maxU, u);
			maxV = Math.max(maxV, v);
		}

		var width	= texture.method_4307	();
		var height	= texture.method_4323	();

		var minX	= class_3532.method_15375	(minU * texture.method_4307	());
		var minY	= class_3532.method_15375	(minV * texture.method_4323	());
		var maxX	= class_3532.method_15386	(maxU * texture.method_4307	());
		var maxY	= class_3532.method_15386	(maxV * texture.method_4323	());

		for (		var x = minX; x <= maxX; x ++) {
			for (	var y = minY; y <= maxY; y ++) {
				var clampedX = x % width;
				var clampedY = y % height;

				clampedX = clampedX < 0 ? width		+ clampedX : clampedX;
				clampedY = clampedY < 0 ? height	+ clampedY : clampedY;

				if (class_5253.class_8045.method_48342(texture.method_4315(clampedX, clampedY)) != 0) {
					return false;
				}
			}
		}

		return true;
	}
}
