package com.github.argon4w.acceleratedrendering.features.culling;

import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramDispatcher;
import com.github.argon4w.acceleratedrendering.core.programs.culling.ICullingProgramSelector;
import com.github.argon4w.acceleratedrendering.core.utils.RenderTypeUtils;
import net.minecraft.class_1921;
import net.minecraft.class_293;
import net.minecraft.class_2960;

public class OrientationCullingProgramSelector implements ICullingProgramSelector {

	private final ICullingProgramSelector	parent;
	private final ICullingProgramDispatcher	quadDispatcher;
	private final ICullingProgramDispatcher	triangleDispatcher;

	public OrientationCullingProgramSelector(
			ICullingProgramSelector	parent,
			class_2960		quadProgramKey,
			class_2960		triangleProgramKey
	) {
		this.parent				= parent;
		this.quadDispatcher		= new OrientationCullingProgramDispatcher(class_293.class_5596.field_27382,		quadProgramKey);
		this.triangleDispatcher	= new OrientationCullingProgramDispatcher(class_293.class_5596.field_27379,	triangleProgramKey);
	}

	@Override
	public ICullingProgramDispatcher select(class_1921 renderType) {
		if (			OrientationCullingFeature	.isEnabled				()
				&&	(	OrientationCullingFeature	.shouldIgnoreCullState	() || RenderTypeUtils.isCulled(renderType))
		) {
			return switch (renderType.field_20973) {
				case field_27382		-> quadDispatcher;
				case field_27379	-> triangleDispatcher;
				default			-> parent.select(renderType);
			};
		}

		return parent.select(renderType);
	}
}
