package com.github.argon4w.acceleratedrendering.features.entities.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreBuffers;
import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.CoreStates;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.layers.LayerDrawType;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.class_1309;
import net.minecraft.class_308;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(class_490.class)
public class InventoryScreenMixin {

	@WrapMethod(method = "method_29977")
	private static void startRenderingGui(
        class_898	entityrenderdispatcher,
        class_1309			entity,
        class_332				guiGraphics,
        Operation<Void> operation
	) {
		CoreFeature.setRenderingGui();


		if (CoreFeature.isGuiBatching()) {
			CoreFeature.forceSetDefaultLayer				(2);
			CoreFeature.forceSetDefaultLayerBeforeFunction	(class_308::method_34742);
			CoreFeature.forceSetDefaultLayerAfterFunction	(class_308::method_24211);
		}
		operation.call(
				entityrenderdispatcher,
				entity,
				guiGraphics
		);

		CoreFeature.resetRenderingGui();

		if (CoreFeature.isGuiBatching()) {
			CoreFeature.resetDefaultLayer				();
			CoreFeature.resetDefaultLayerBeforeFunction	();
			CoreFeature.resetDefaultLayerAfterFunction	();
		} else {
			CoreStates						.recordBuffers	();
			CoreBuffers.ENTITY				.prepareBuffers	();
			CoreBuffers.BLOCK				.prepareBuffers	();
			CoreBuffers.POS					.prepareBuffers	();
			CoreBuffers.POS_TEX				.prepareBuffers	();
			CoreBuffers.POS_TEX_COLOR		.prepareBuffers	();
			CoreBuffers.POS_COLOR_TEX_LIGHT	.prepareBuffers	();
			CoreStates						.restoreBuffers	();

			CoreBuffers.ENTITY				.drawBuffers	(LayerDrawType.ALL);
			CoreBuffers.BLOCK				.drawBuffers	(LayerDrawType.ALL);
			CoreBuffers.POS					.drawBuffers	(LayerDrawType.ALL);
			CoreBuffers.POS_TEX				.drawBuffers	(LayerDrawType.ALL);
			CoreBuffers.POS_TEX_COLOR		.drawBuffers	(LayerDrawType.ALL);
			CoreBuffers.POS_COLOR_TEX_LIGHT	.drawBuffers	(LayerDrawType.ALL);

			CoreBuffers.ENTITY				.clearBuffers	();
			CoreBuffers.BLOCK				.clearBuffers	();
			CoreBuffers.POS					.clearBuffers	();
			CoreBuffers.POS_TEX				.clearBuffers	();
			CoreBuffers.POS_TEX_COLOR		.clearBuffers	();
			CoreBuffers.POS_COLOR_TEX_LIGHT	.clearBuffers	();
		}
	}
}
