package com.github.argon4w.acceleratedrendering.features.items.mixins.models;

import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IAcceleratedVertexConsumer;
import com.github.argon4w.acceleratedrendering.features.items.BakedModelExtension;
import com.github.argon4w.acceleratedrendering.features.items.IAcceleratedBakedModel;
import lombok.Getter;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_1087;
import net.minecraft.class_1097;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Getter
@ExtensionMethod(BakedModelExtension.class)
@Mixin			(class_1097	.class)
public class WeightedBakedModelMixin implements IAcceleratedBakedModel {

	@Unique private			boolean									accelerated;
	@Unique private			boolean									acceleratedInHand;
	@Unique private			boolean									acceleratedInGui;

	@Shadow @Final private	List<class_6008.class_6010<class_1087>>	list;
	@Shadow @Final private	int										totalWeight;

	@Inject(
			method	= "<init>",
			at		= @At("TAIL")
	)
	public void checkAccelerationSupport(List<class_6008.class_6010<class_1087>> list, CallbackInfo ci) {
		accelerated			= true;
		acceleratedInHand	= true;
		acceleratedInGui	= true;

		for (class_6008.class_6010<class_1087> wrapper : list) {
			var extension = wrapper.comp_2542().getAccelerated();

			accelerated			&= extension.isAccelerated		();
			acceleratedInHand	&= extension.isAcceleratedInHand();
			acceleratedInGui	&= extension.isAcceleratedInGui	();
		}
	}

	@Override
	public void renderItemFast(
			class_1799					itemStack,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							light,
			int							overlay
	) {
		var model = class_6011.method_34985(list, Math.abs((int) random.method_43055()) % totalWeight);

		if (model.isPresent()) {
			model
					.get			()
					.comp_2542			()
					.getAccelerated	()
					.renderItemFast	(
							itemStack,
							random,
							pose,
							extension,
							light,
							overlay
					);
		}
	}

	@Override
	public void renderBlockFast(
			class_2680					state,
			class_5819				random,
			class_4587.class_4665				pose,
			IAcceleratedVertexConsumer	extension,
			int							light,
			int							overlay,
			int							color
	) {
		var model = class_6011.method_34985(list, Math.abs((int) random.method_43055()) % totalWeight);

		if (model.isPresent()) {
			model
					.get			()
					.comp_2542			()
					.getAccelerated	()
					.renderBlockFast(
							state,
							random,
							pose,
							extension,
							light,
							overlay,
							getCustomColor(-1, color)
					);
		}
	}

	@Override
	public int getCustomColor(int layer, int color) {
		return color;
	}
}
