package com.github.argon4w.acceleratedrendering.features.text.mixins;

import com.github.argon4w.acceleratedrendering.core.CoreFeature;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.IBufferGraph;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.builders.VertexConsumerExtension;
import com.github.argon4w.acceleratedrendering.core.buffers.accelerated.renderers.IAcceleratedRenderer;
import com.github.argon4w.acceleratedrendering.core.meshes.IMesh;
import com.github.argon4w.acceleratedrendering.core.meshes.collectors.SimpleMeshCollector;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedBakedGlyphRenderer;
import com.github.argon4w.acceleratedrendering.features.text.AcceleratedTextRenderingFeature;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.experimental.ExtensionMethod;
import net.minecraft.class_382;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@ExtensionMethod(value = VertexConsumerExtension.class)
@Mixin			(value = class_382				.class, priority = Integer.MIN_VALUE)
public class BakedGlyphMixin implements IAcceleratedRenderer<class_382.class_328> {

	@Shadow @Final public			float												u0;
	@Shadow @Final public			float												v0;
	@Shadow @Final public			float												u1;
	@Shadow @Final public			float												v1;

	@Unique private static	final	Matrix3f											NORMAL			= new Matrix3f();

	@Unique private			final	AcceleratedBakedGlyphRenderer						normalRenderer	= new AcceleratedBakedGlyphRenderer	((class_382) (Object) this, false);
	@Unique private			final	AcceleratedBakedGlyphRenderer						italicRenderer	= new AcceleratedBakedGlyphRenderer	((class_382) (Object) this, true);
	@Unique private			final	Map<class_382.class_328, Map<IBufferGraph, IMesh>>	effectMeshes	= new Object2ObjectOpenHashMap<>	();

	@Inject(
			method		= "render",
			at			= @At("HEAD"),
			cancellable	= true
	)
	public void renderFast(
			boolean			pItalic,
			float			pX,
			float			pY,
			Matrix4f		pMatrix,
			class_4588	pBuffer,
			float			pRed,
			float			pGreen,
			float			pBlue,
			float			pAlpha,
			int				pPackedLight,
			CallbackInfo	ci
	) {
		var extension = pBuffer.getAccelerated();

		if (		CoreFeature						.isRenderingLevel				()
				&&	AcceleratedTextRenderingFeature	.isEnabled						()
				&&	AcceleratedTextRenderingFeature	.shouldUseAcceleratedPipeline	()
				&&	extension						.isAccelerated					()
		) {
			ci			.cancel		();
			extension	.doRender	(
					pItalic
							? italicRenderer
							: normalRenderer,
					new Vector2f(pX, pY),
					pMatrix,
					null,
					pPackedLight,
					class_4608	.field_21444,
					class_5253.class_5254.method_27764(
							(int) (pAlpha	* 255.0f),
							(int) (pRed		* 255.0f),
							(int) (pGreen	* 255.0f),
							(int) (pBlue	* 255.0f)
					)
			);
		}
	}

	@Inject(
			method		= "renderEffect",
			at			= @At("HEAD"),
			cancellable	= true
	)
	public void renderEffectFast(
			class_382.class_328	effect,
			Matrix4f			matrix,
			class_4588		buffer,
			int					packedLight,
			CallbackInfo		ci
	) {
		var extension = buffer.getAccelerated();

		if (		CoreFeature						.isRenderingLevel				()
				&&	AcceleratedTextRenderingFeature	.isEnabled						()
				&&	AcceleratedTextRenderingFeature	.shouldUseAcceleratedPipeline	()
				&&	extension						.isAccelerated					()
		) {
			ci			.cancel		();
			extension	.doRender	(
					this,
					effect,
					matrix,
					NORMAL,
					packedLight,
					class_4608	.field_21444,
					class_5253.class_5254.method_27764(
							(int) (effect.field_2009 * 255.0f),
							(int) (effect.field_2004 * 255.0f),
							(int) (effect.field_2003 * 255.0f),
							(int) (effect.field_2010 * 255.0f)
					)
			);
		}
	}

	@Unique
	@Override
	public void render(
			class_4588		vertexConsumer,
			class_382.class_328	context,
			Matrix4f			transform,
			Matrix3f			normal,
			int					light,
			int					overlay,
			int					color
	) {
		var extension	= vertexConsumer.getAccelerated	();
		var meshes		= effectMeshes	.get			(context);

		extension.beginTransform(transform, normal);

		if (meshes == null) {
			meshes = new Object2ObjectOpenHashMap<>	();
			effectMeshes.put						(context, meshes);
		}

		var mesh = meshes.get(extension);

		if (mesh != null) {
			mesh.write(
					extension,
					color,
					light,
					overlay
			);

			extension.endTransform();
			return;
		}

		var meshCollector	= new SimpleMeshCollector	(extension.getLayout());
		var meshBuilder		= extension.decorate		(meshCollector);

		var positions = new Vector2f[] {
				new Vector2f(context.field_2008, context.field_2007),
				new Vector2f(context.field_2006, context.field_2007),
				new Vector2f(context.field_2006, context.field_2005),
				new Vector2f(context.field_2008, context.field_2005),
		};

		var texCoords = new Vector2f[] {
				new Vector2f(u0, v0),
				new Vector2f(u0, v1),
				new Vector2f(u1, v1),
				new Vector2f(u1, v0),
		};

		for (var i = 0; i < 4; i ++) {
			var position = new Vector3f(positions[i], context.field_20911);
			var texCoord = texCoords[i];

			meshBuilder
					.addVertex	(position)
					.setColor	(-1)
					.setUv		(texCoord.x, texCoord.y)
					.setLight	(0);
		}

		mesh = AcceleratedTextRenderingFeature
				.getMeshType()
				.getBuilder	()
				.build		(meshCollector);

		meshes	.put	(extension, mesh);
		mesh	.write	(
				extension,
				color,
				light,
				overlay
		);

		extension.endTransform();
	}
}
